/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.RelationshipState;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.util.DiffSets;

public class TxStateTransactionDataSnapshot
implements TransactionData {
    private final TxState state;
    private final NodeProxy.NodeLookup nodeLookup;
    private final RelationshipProxy.RelationshipLookups relLookup;
    private final Collection<PropertyEntry<Node>> assignedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> assignedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> assignedLabels = new ArrayList<LabelEntry>();
    private final Collection<PropertyEntry<Node>> removedNodeProperties = new ArrayList<PropertyEntry<Node>>();
    private final Collection<PropertyEntry<Relationship>> removedRelationshipProperties = new ArrayList<PropertyEntry<Relationship>>();
    private final Collection<LabelEntry> removedLabels = new ArrayList<LabelEntry>();
    private final ThreadToStatementContextBridge bridge;

    public TxStateTransactionDataSnapshot(TxState state, NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relLookup, ThreadToStatementContextBridge bridge, StoreReadLayer storeReadLayer) {
        this.state = state;
        this.nodeLookup = nodeLookup;
        this.relLookup = relLookup;
        this.bridge = bridge;
        this.takeSnapshot(state, storeReadLayer);
    }

    @Override
    public Iterable<Node> createdNodes() {
        return this.map2Nodes(this.state.addedAndRemovedNodes().getAdded());
    }

    @Override
    public Iterable<Node> deletedNodes() {
        return this.map2Nodes(this.state.addedAndRemovedNodes().getRemoved());
    }

    @Override
    public Iterable<Relationship> createdRelationships() {
        return this.map2Rels(this.state.addedAndRemovedRels().getAdded());
    }

    @Override
    public Iterable<Relationship> deletedRelationships() {
        return this.map2Rels(this.state.addedAndRemovedRels().getRemoved());
    }

    @Override
    public boolean isDeleted(Node node) {
        return this.state.nodeIsDeletedInThisTx(node.getId());
    }

    @Override
    public boolean isDeleted(Relationship relationship) {
        return this.state.relationshipIsDeletedInThisTx(relationship.getId());
    }

    @Override
    public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
        return this.assignedNodeProperties;
    }

    @Override
    public Iterable<PropertyEntry<Node>> removedNodeProperties() {
        return this.removedNodeProperties;
    }

    @Override
    public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
        return this.assignedRelationshipProperties;
    }

    @Override
    public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
        return this.removedRelationshipProperties;
    }

    @Override
    public Iterable<LabelEntry> removedLabels() {
        return this.removedLabels;
    }

    @Override
    public Iterable<LabelEntry> assignedLabels() {
        return this.assignedLabels;
    }

    private void takeSnapshot(TxState state, StoreReadLayer storeReadLayer) {
        try {
            Integer property;
            Iterator<Integer> removed;
            DefinedProperty property2;
            Iterator<DefinedProperty> added;
            DefinedProperty prop;
            Iterator<DefinedProperty> props;
            for (Long nodeId : state.addedAndRemovedNodes().getRemoved()) {
                props = storeReadLayer.nodeGetAllProperties(nodeId);
                while (props.hasNext()) {
                    prop = props.next();
                    this.removedNodeProperties.add(new NodePropertyEntryView(nodeId, storeReadLayer.propertyKeyGetName(prop.propertyKeyId()), null, prop.value()));
                }
                PrimitiveIntIterator labels = storeReadLayer.nodeGetLabels(nodeId);
                while (labels.hasNext()) {
                    this.removedLabels.add(new LabelEntryView(nodeId, storeReadLayer.labelGetName(labels.next())));
                }
            }
            for (Long relId : state.addedAndRemovedRels().getRemoved()) {
                props = storeReadLayer.relationshipGetAllProperties(relId);
                while (props.hasNext()) {
                    prop = props.next();
                    this.removedRelationshipProperties.add(new RelationshipPropertyEntryView(relId, storeReadLayer.propertyKeyGetName(prop.propertyKeyId()), null, prop.value()));
                }
            }
            for (NodeState nodeState : state.modifiedNodes()) {
                added = nodeState.addedAndChangedProperties();
                while (added.hasNext()) {
                    property2 = added.next();
                    this.assignedNodeProperties.add(new NodePropertyEntryView(nodeState.getId(), storeReadLayer.propertyKeyGetName(property2.propertyKeyId()), property2.value(), this.committedValue(storeReadLayer, nodeState, property2.propertyKeyId())));
                }
                removed = nodeState.removedProperties();
                while (removed.hasNext()) {
                    property = removed.next();
                    this.removedNodeProperties.add(new NodePropertyEntryView(nodeState.getId(), storeReadLayer.propertyKeyGetName(property), null, this.committedValue(storeReadLayer, nodeState, (int)property)));
                }
                DiffSets<Integer> labels = nodeState.labelDiffSets();
                for (Integer label : labels.getAdded()) {
                    this.assignedLabels.add(new LabelEntryView(nodeState.getId(), storeReadLayer.labelGetName(label)));
                }
                for (Integer label : labels.getRemoved()) {
                    this.removedLabels.add(new LabelEntryView(nodeState.getId(), storeReadLayer.labelGetName(label)));
                }
            }
            for (RelationshipState relState : state.modifiedRelationships()) {
                added = relState.addedAndChangedProperties();
                while (added.hasNext()) {
                    property2 = added.next();
                    this.assignedRelationshipProperties.add(new RelationshipPropertyEntryView(relState.getId(), storeReadLayer.propertyKeyGetName(property2.propertyKeyId()), property2.value(), this.committedValue(storeReadLayer, relState, property2.propertyKeyId())));
                }
                removed = relState.removedProperties();
                while (removed.hasNext()) {
                    property = removed.next();
                    this.removedRelationshipProperties.add(new RelationshipPropertyEntryView(relState.getId(), storeReadLayer.propertyKeyGetName(property), null, this.committedValue(storeReadLayer, relState, (int)property)));
                }
            }
        }
        catch (EntityNotFoundException | LabelNotFoundKernelException | PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "An entity that does not exist was modified.", e);
        }
    }

    private Iterable<Node> map2Nodes(Iterable<Long> added) {
        return Iterables.map(new Function<Long, Node>(){

            public Node apply(Long id) {
                return new NodeProxy(id, TxStateTransactionDataSnapshot.this.nodeLookup, TxStateTransactionDataSnapshot.this.relLookup, TxStateTransactionDataSnapshot.this.bridge);
            }
        }, added);
    }

    private Iterable<Relationship> map2Rels(Iterable<Long> added) {
        return Iterables.map(new Function<Long, Relationship>(){

            public Relationship apply(Long id) {
                return new RelationshipProxy(id, TxStateTransactionDataSnapshot.this.relLookup, TxStateTransactionDataSnapshot.this.bridge);
            }
        }, added);
    }

    private Object committedValue(StoreReadLayer storeReadLayer, NodeState nodeState, int property) {
        try {
            if (this.state.nodeIsAddedInThisTx(nodeState.getId())) {
                return null;
            }
            return storeReadLayer.nodeGetProperty(nodeState.getId(), property).value();
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            return null;
        }
    }

    private Object committedValue(StoreReadLayer storeReadLayer, RelationshipState relState, int property) {
        try {
            if (this.state.relationshipIsAddedInThisTx(relState.getId())) {
                return null;
            }
            return storeReadLayer.relationshipGetProperty(relState.getId(), property).value();
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            return null;
        }
    }

    private class LabelEntryView
    implements LabelEntry {
        private final long nodeId;
        private final Label label;

        public LabelEntryView(long nodeId, String labelName) {
            this.nodeId = nodeId;
            this.label = DynamicLabel.label(labelName);
        }

        @Override
        public Label label() {
            return this.label;
        }

        @Override
        public Node node() {
            return new NodeProxy(this.nodeId, TxStateTransactionDataSnapshot.this.nodeLookup, TxStateTransactionDataSnapshot.this.relLookup, TxStateTransactionDataSnapshot.this.bridge);
        }

        public String toString() {
            return "LabelEntryView{nodeId=" + this.nodeId + ", label=" + this.label + '}';
        }
    }

    private class RelationshipPropertyEntryView
    implements PropertyEntry<Relationship> {
        private final long relId;
        private final String key;
        private final Object newValue;
        private final Object oldValue;

        public RelationshipPropertyEntryView(long relId, String key, Object newValue, Object oldValue) {
            this.relId = relId;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        @Override
        public Relationship entity() {
            return new RelationshipProxy(this.relId, TxStateTransactionDataSnapshot.this.relLookup, TxStateTransactionDataSnapshot.this.bridge);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Object previouslyCommitedValue() {
            return this.oldValue;
        }

        @Override
        public Object value() {
            if (this.newValue == null) {
                throw new IllegalStateException("This property has been removed, it has no value anymore.");
            }
            return this.newValue;
        }

        public String toString() {
            return "RelationshipPropertyEntryView{relId=" + this.relId + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }

    private class NodePropertyEntryView
    implements PropertyEntry<Node> {
        private final long nodeId;
        private final String key;
        private final Object newValue;
        private final Object oldValue;

        public NodePropertyEntryView(long nodeId, String key, Object newValue, Object oldValue) {
            this.nodeId = nodeId;
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        @Override
        public Node entity() {
            return new NodeProxy(this.nodeId, TxStateTransactionDataSnapshot.this.nodeLookup, TxStateTransactionDataSnapshot.this.relLookup, TxStateTransactionDataSnapshot.this.bridge);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Object previouslyCommitedValue() {
            return this.oldValue;
        }

        @Override
        public Object value() {
            if (this.newValue == null) {
                throw new IllegalStateException("This property has been removed, it has no value anymore.");
            }
            return this.newValue;
        }

        public String toString() {
            return "NodePropertyEntryView{nodeId=" + this.nodeId + ", key='" + this.key + '\'' + ", newValue=" + this.newValue + ", oldValue=" + this.oldValue + '}';
        }
    }
}

