/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsRecordSerializer;
import org.neo4j.kernel.impl.store.counts.CountsStoreWriter;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordVisitor;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStoreHeader;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class CountsStore
extends SortedKeyValueStore<CountsKey, Register.CopyableDoubleLongRegister> {
    static final int RECORD_SIZE = 32;
    static final CountsRecordSerializer RECORD_SERIALIZER = CountsRecordSerializer.INSTANCE;
    static final CountsStoreWriter.Factory WRITER_FACTORY = new CountsStoreWriter.Factory();

    public CountsStore(FileSystemAbstraction fs, PageCache pageCache, File file, PagedFile pages, SortedKeyValueStoreHeader header) {
        super(fs, pageCache, file, pages, header, RECORD_SERIALIZER, 32, WRITER_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createEmpty(PageCache pageCache, File storeFile, SortedKeyValueStoreHeader header) {
        try {
            PagedFile pages = CountsStore.mapCountsStore(pageCache, storeFile);
            try {
                header.write(pages);
            }
            finally {
                pages.flush();
                pageCache.unmap(storeFile);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    public static CountsStore open(FileSystemAbstraction fs, PageCache pageCache, File storeFile) throws IOException {
        PagedFile pages = CountsStore.mapCountsStore(pageCache, storeFile);
        try {
            SortedKeyValueStoreHeader header = SortedKeyValueStoreHeader.read(32, pages);
            CountsStore countsStore = new CountsStore(fs, pageCache, storeFile, pages, header);
            final Register.LongRegister keys = Registers.newLongRegister((long)0L);
            countsStore.accept(new KeyValueRecordVisitor<CountsKey, Register.CopyableDoubleLongRegister>(){

                @Override
                public void visit(CountsKey key, Register.CopyableDoubleLongRegister register) {
                    if (register.hasValues(0L, 0L)) {
                        throw new UnderlyingStorageException("Counts store contains unexpected value (0,0)");
                    }
                    keys.increment(1L);
                }
            }, Registers.newDoubleLongRegister());
            if (keys.read() != (long)header.dataRecords()) {
                throw new UnderlyingStorageException("Counts store is corrupted");
            }
            return countsStore;
        }
        catch (RuntimeException e) {
            pageCache.unmap(storeFile);
            throw e;
        }
    }

    private static PagedFile mapCountsStore(PageCache pageCache, File storeFile) throws IOException {
        int pageSize = pageCache.pageSize() - pageCache.pageSize() % 32;
        return pageCache.map(storeFile, pageSize);
    }
}

