/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.standard;

import java.io.IOException;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.standard.StoreIdGenerator;

public class StoreToolkit {
    private final int recordSize;
    private final int pageSize;
    private final long firstRecordId;
    private final StoreChannel channel;
    private final StoreIdGenerator idGenerator;

    public StoreToolkit(int recordSize, int pageSize, long firstRecordId, StoreChannel channel, StoreIdGenerator idGenerator) {
        this.recordSize = recordSize;
        this.pageSize = pageSize;
        this.firstRecordId = firstRecordId;
        this.channel = channel;
        this.idGenerator = idGenerator;
    }

    public long pageId(long recordId) {
        return recordId * (long)this.recordSize / (long)this.pageSize;
    }

    public int recordOffset(long recordId) {
        return (int)(recordId * (long)this.recordSize % (long)this.pageSize);
    }

    public int pageSize() {
        return this.pageSize - this.pageSize % this.recordSize;
    }

    public int recordSize() {
        return this.recordSize;
    }

    public long highestKnownId() {
        return this.idGenerator.highestIdInUse();
    }

    public long firstRecordId() {
        return this.firstRecordId;
    }

    public long fileSize() throws IOException {
        return this.channel.size();
    }
}

