/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;

public enum FileOperation {
    COPY{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, File fromDirectory, File toDirectory) throws IOException {
            File fromFile = new File(fromDirectory, fileName);
            File toFile = new File(toDirectory, fileName);
            fs.copyFile(fromFile, toFile);
        }
    }
    ,
    MOVE{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, File fromDirectory, File toDirectory) throws IOException {
            File fromFile = new File(fromDirectory, fileName);
            fs.moveToDirectory(fromFile, toDirectory);
        }
    }
    ,
    DELETE{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, File fromDirectory, File toDirectory) throws IOException {
            fs.deleteFile(new File(fromDirectory, fileName));
        }
    };


    public abstract void perform(FileSystemAbstraction var1, String var2, File var3, File var4) throws IOException;
}

