/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.IOException;
import org.neo4j.helpers.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryReader;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryWriter;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogFilenames;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;

public class LegacyLogs {
    private final FileSystemAbstraction fs;
    private final LegacyLogEntryReader reader;
    private final LegacyLogEntryWriter writer;

    public LegacyLogs(FileSystemAbstraction fs) {
        this(fs, new LegacyLogEntryReader(fs), new LegacyLogEntryWriter(fs));
    }

    LegacyLogs(FileSystemAbstraction fs, LegacyLogEntryReader reader, LegacyLogEntryWriter writer) {
        this.fs = fs;
        this.reader = reader;
        this.writer = writer;
    }

    public void migrateLogs(File storeDir, File migrationDir) throws IOException {
        File[] logFiles;
        for (File file : logFiles = this.fs.listFiles(storeDir, LegacyLogFilenames.versionedLegacyLogFilesFilter)) {
            Pair<LogHeader, IOCursor<LogEntry>> pair = this.reader.openReadableChannel(file);
            LogHeader header = pair.first();
            try (IOCursor<LogEntry> cursor = pair.other();
                 LogVersionedStoreChannel channel = this.writer.openWritableChannel(new File(migrationDir, file.getName()));){
                this.writer.writeLogHeader(channel, header);
                this.writer.writeAllLogEntries(channel, cursor);
            }
        }
    }

    public void moveLogs(File migrationDir, File storeDir) throws IOException {
        File[] logFiles;
        for (File file : logFiles = this.fs.listFiles(migrationDir, LegacyLogFilenames.versionedLegacyLogFilesFilter)) {
            File originalFile = new File(storeDir, file.getName());
            if (originalFile.exists()) {
                this.fs.deleteFile(originalFile);
            }
            this.fs.moveToDirectory(file, storeDir);
        }
    }

    public void renameLogFiles(File storeDir) throws IOException {
        for (File file : this.fs.listFiles(storeDir, LegacyLogFilenames.versionedLegacyLogFilesFilter)) {
            String oldName = file.getName();
            long version = LegacyLogFilenames.getLegacyLogVersion(oldName);
            String newName = "neostore.transaction.db." + version;
            this.fs.renameFile(file, new File(file.getParent(), newName));
        }
        for (File file : this.fs.listFiles(storeDir, LegacyLogFilenames.allLegacyLogFilesFilter)) {
            this.fs.deleteFile(file);
        }
    }
}

