/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.AbstractRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.command.CommandRecordVisitor;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.state.PropertyRecordChange;
import org.neo4j.kernel.impl.util.IdPrettyPrinter;

public abstract class Command {
    private int keyHash;
    private long key;
    private Mode mode;

    protected final void setup(long key, Mode mode) {
        this.mode = mode;
        this.keyHash = (int)(key >>> 32 ^ key);
        this.key = key;
    }

    public abstract void accept(CommandRecordVisitor var1);

    public int hashCode() {
        return this.keyHash;
    }

    public abstract String toString();

    public long getKey() {
        return this.key;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean equals(Object o) {
        return o != null && o.getClass().equals(this.getClass()) && this.getKey() == ((Command)o).getKey();
    }

    public abstract boolean handle(NeoCommandHandler var1) throws IOException;

    protected String beforeAndAfterToString(AbstractBaseRecord before, AbstractBaseRecord after) {
        return String.format(" -%s%n         +%s", before, after);
    }

    public static class CountsCommand
    extends Command {
        private int startLabelId;
        private int typeId;
        private int endLabelId;
        private long delta;

        public CountsCommand init(int startLabelId, int typeId, int endLabelId, long delta) {
            assert (startLabelId != -1 || endLabelId != -1) : String.format("CountsCommand should only be used for composite counts. The key may contain at most one wildcard label. startLabelId=%s, typeId=%s, endLabelId=%s", startLabelId, typeId, endLabelId);
            assert (delta != 0L) : "Tried to create a CountsCommand for something that didn't change any count";
            this.startLabelId = startLabelId;
            this.typeId = typeId;
            this.endLabelId = endLabelId;
            this.delta = delta;
            return this;
        }

        @Override
        public String toString() {
            return String.format("UpdateCounts[(%s)-%s->(%s) %s %d]", IdPrettyPrinter.label(this.startLabelId), IdPrettyPrinter.relationshipType(this.typeId), IdPrettyPrinter.label(this.endLabelId), this.delta < 0L ? "-" : "+", Math.abs(this.delta));
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitUpdateCountsCommand(this);
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
        }

        public int startLabelId() {
            return this.startLabelId;
        }

        public int typeId() {
            return this.typeId;
        }

        public int endLabelId() {
            return this.endLabelId;
        }

        public long delta() {
            return this.delta;
        }
    }

    public static class SchemaRuleCommand
    extends Command {
        private Collection<DynamicRecord> recordsBefore;
        private Collection<DynamicRecord> recordsAfter;
        private SchemaRule schemaRule;

        public SchemaRuleCommand init(Collection<DynamicRecord> recordsBefore, Collection<DynamicRecord> recordsAfter, SchemaRule schemaRule) {
            this.setup(IteratorUtil.first(recordsAfter).getId(), Mode.fromRecordState(IteratorUtil.first(recordsAfter)));
            this.recordsBefore = recordsBefore;
            this.recordsAfter = recordsAfter;
            this.schemaRule = schemaRule;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitSchemaRule(this.recordsAfter);
        }

        @Override
        public String toString() {
            if (this.schemaRule != null) {
                return (Object)((Object)this.getMode()) + ":" + this.schemaRule.toString();
            }
            return "SchemaRule" + this.recordsAfter;
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitSchemaRuleCommand(this);
        }

        public Collection<DynamicRecord> getRecordsAfter() {
            return Collections.unmodifiableCollection(this.recordsAfter);
        }

        public SchemaRule getSchemaRule() {
            return this.schemaRule;
        }

        public Collection<DynamicRecord> getRecordsBefore() {
            return this.recordsBefore;
        }
    }

    public static class LabelTokenCommand
    extends TokenCommand<LabelTokenRecord> {
        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitLabelToken((LabelTokenRecord)this.record);
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitLabelTokenCommand(this);
        }
    }

    public static class RelationshipTypeTokenCommand
    extends TokenCommand<RelationshipTypeTokenRecord> {
        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationshipTypeToken((RelationshipTypeTokenRecord)this.record);
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitRelationshipTypeTokenCommand(this);
        }
    }

    public static abstract class TokenCommand<RECORD extends TokenRecord>
    extends Command {
        protected RECORD record;

        public TokenCommand<RECORD> init(RECORD record) {
            this.setup(((AbstractRecord)record).getId(), Mode.fromRecordState(record));
            this.record = record;
            return this;
        }

        public RECORD getRecord() {
            return this.record;
        }

        @Override
        public String toString() {
            return ((TokenRecord)this.record).toString();
        }
    }

    public static class PropertyCommand
    extends Command
    implements PropertyRecordChange {
        private PropertyRecord before;
        private PropertyRecord after;

        public PropertyCommand init(PropertyRecord before, PropertyRecord after) {
            this.setup(after.getId(), Mode.fromRecordState(after));
            this.before = before;
            this.after = after;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitProperty(this.after);
        }

        @Override
        public String toString() {
            return this.beforeAndAfterToString(this.before, this.after);
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitPropertyCommand(this);
        }

        @Override
        public PropertyRecord getBefore() {
            return this.before;
        }

        @Override
        public PropertyRecord getAfter() {
            return this.after;
        }

        public long getNodeId() {
            return this.after.getNodeId();
        }

        public long getRelId() {
            return this.after.getRelId();
        }
    }

    public static class PropertyKeyTokenCommand
    extends TokenCommand<PropertyKeyTokenRecord> {
        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitPropertyKeyToken((PropertyKeyTokenRecord)this.record);
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitPropertyKeyTokenCommand(this);
        }
    }

    public static class NeoStoreCommand
    extends Command {
        private NeoStoreRecord record;

        public NeoStoreCommand init(NeoStoreRecord record) {
            if (record != null) {
                this.setup(record.getId(), Mode.fromRecordState(record));
            }
            this.record = record;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitNeoStore(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitNeoStoreCommand(this);
        }

        public NeoStoreRecord getRecord() {
            return this.record;
        }
    }

    public static class RelationshipGroupCommand
    extends Command {
        private RelationshipGroupRecord record;

        public RelationshipGroupCommand init(RelationshipGroupRecord record) {
            this.setup(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationshipGroup(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitRelationshipGroupCommand(this);
        }

        public RelationshipGroupRecord getRecord() {
            return this.record;
        }
    }

    public static class RelationshipCommand
    extends Command {
        private RelationshipRecord record;

        public RelationshipCommand init(RelationshipRecord record) {
            this.setup(record.getId(), Mode.fromRecordState(record));
            this.record = record;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitRelationship(this.record);
        }

        @Override
        public String toString() {
            return this.record.toString();
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitRelationshipCommand(this);
        }

        public RelationshipRecord getRecord() {
            return this.record;
        }
    }

    public static class NodeCommand
    extends Command {
        private NodeRecord before;
        private NodeRecord after;

        public NodeCommand init(NodeRecord before, NodeRecord after) {
            this.setup(after.getId(), Mode.fromRecordState(after));
            this.before = before;
            this.after = after;
            return this;
        }

        @Override
        public void accept(CommandRecordVisitor visitor) {
            visitor.visitNode(this.after);
        }

        @Override
        public boolean handle(NeoCommandHandler handler) throws IOException {
            return handler.visitNodeCommand(this);
        }

        @Override
        public String toString() {
            return this.beforeAndAfterToString(this.before, this.after);
        }

        public NodeRecord getBefore() {
            return this.before;
        }

        public NodeRecord getAfter() {
            return this.after;
        }
    }

    public static enum Mode {
        CREATE,
        UPDATE,
        DELETE;


        public static Mode fromRecordState(boolean created, boolean inUse) {
            if (!inUse) {
                return DELETE;
            }
            if (created) {
                return CREATE;
            }
            return UPDATE;
        }

        public static Mode fromRecordState(AbstractBaseRecord record) {
            return Mode.fromRecordState(record.isCreated(), record.inUse());
        }
    }
}

