/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.transaction.command.LogHandler;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;

public class LogFilter
implements LogHandler {
    private final Function<List<LogEntry>, List<LogEntry>> interceptor;
    private final LogHandler delegate;
    private final List<LogEntry> logEntries;

    public LogFilter(Function<List<LogEntry>, List<LogEntry>> interceptor, LogHandler delegate) {
        this.interceptor = interceptor;
        this.delegate = delegate;
        this.logEntries = new ArrayList<LogEntry>();
    }

    @Override
    public void startLog() {
        this.logEntries.clear();
    }

    @Override
    public void startEntry(LogEntryStart startEntry) {
        this.logEntries.add(startEntry);
    }

    @Override
    public void onePhaseCommitEntry(OnePhaseCommit onePhaseCommitEntry) {
        this.logEntries.add(onePhaseCommitEntry);
    }

    @Override
    public void commandEntry(LogEntryCommand commandEntry) {
        this.logEntries.add(commandEntry);
    }

    @Override
    public void endLog(boolean success) throws IOException {
        List filtered = (List)this.interceptor.apply(this.logEntries);
        this.delegate.startLog();
        for (LogEntry entry : filtered) {
            entry.accept(this.delegate);
        }
        this.delegate.endLog(success);
        this.logEntries.clear();
    }
}

