/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.function.Factory;
import org.neo4j.kernel.impl.transaction.log.AbstractPhysicalTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.BatchingForceThread;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WaitStrategy;
import org.neo4j.kernel.impl.util.Counter;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.NumberUtil;

public class BatchingPhysicalTransactionAppender
extends AbstractPhysicalTransactionAppender {
    public static final WaitStrategy DEFAULT_WAIT_STRATEGY = new WaitStrategy.Park(10);
    private final Counter appenderTicket;
    AtomicReference<ThreadLink> threadLinkHead = new AtomicReference<ThreadLink>(ThreadLink.END);
    private final Counter forceTicket;
    private boolean shutDown;
    private final BatchingForceThread forceThread;

    public BatchingPhysicalTransactionAppender(LogFile logFile, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, IdOrderingQueue legacyIndexTransactionOrdering, Factory<Counter> counting, WaitStrategy idleBackoffStrategy) {
        super(logFile, transactionMetadataCache, transactionIdStore, legacyIndexTransactionOrdering);
        this.appenderTicket = (Counter)counting.newInstance();
        this.forceTicket = (Counter)counting.newInstance();
        this.forceThread = new BatchingForceThread(new BatchingForceThread.Operation(){

            @Override
            public boolean perform() throws IOException {
                long currentAppenderTicket = BatchingPhysicalTransactionAppender.this.appenderTicket.get();
                if (BatchingPhysicalTransactionAppender.this.forceTicket.get() == currentAppenderTicket) {
                    return false;
                }
                BatchingPhysicalTransactionAppender.this.force();
                BatchingPhysicalTransactionAppender.this.forceTicket.set(currentAppenderTicket);
                ThreadLink linkedOut = BatchingPhysicalTransactionAppender.this.threadLinkHead.getAndSet(ThreadLink.END);
                while (linkedOut != ThreadLink.END) {
                    LockSupport.unpark(linkedOut.thread);
                    while (linkedOut.next == null) {
                    }
                    linkedOut = linkedOut.next;
                }
                return true;
            }
        }, idleBackoffStrategy);
        this.forceThread.start();
    }

    @Override
    protected void emptyBufferIntoChannel() throws IOException {
    }

    @Override
    protected long getNextTicket() {
        return this.appenderTicket.incrementAndGet();
    }

    @Override
    protected void forceAfterAppend(long ticket) throws IOException {
        ThreadLink threadLink = new ThreadLink(Thread.currentThread());
        threadLink.next = this.threadLinkHead.getAndSet(threadLink);
        while (!(ticket <= this.forceTicket.get() && NumberUtil.haveSameSign(ticket, this.forceTicket.get()) || this.shutDown || !this.forceThread.checkHealth())) {
            LockSupport.unpark(this.forceThread);
            LockSupport.parkNanos(100000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force() throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.channel.emptyBufferIntoChannelAndClearIt();
        }
        this.forceChannel();
    }

    @Override
    public void close() {
        this.forceThread.halt();
        try {
            this.forceThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.shutDown = true;
        super.close();
    }

    static class ThreadLink {
        volatile ThreadLink next = null;
        Thread thread;
        static final ThreadLink END = new ThreadLink(null);

        public ThreadLink(Thread thread) {
            this.thread = thread;
        }
    }
}

