/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.command.LogReader;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.DefaultLogEntryParserFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReaderFactory;

public class LogDeserializer
implements LogReader<ReadableVersionableLogChannel> {
    private final LogEntryReader<ReadableVersionableLogChannel> logEntryReader;

    public LogDeserializer() {
        this(new DefaultLogEntryParserFactory(), new CommandReaderFactory.Default());
    }

    public LogDeserializer(LogEntryParserFactory logEntryParserFactory, CommandReaderFactory commandReaderFactory) {
        this.logEntryReader = new LogEntryReaderFactory(logEntryParserFactory, commandReaderFactory).versionable();
    }

    @Override
    public IOCursor<LogEntry> logEntries(ReadableVersionableLogChannel channel) {
        return new LogCursor(channel);
    }

    private class LogCursor
    implements IOCursor<LogEntry> {
        private final ReadableVersionableLogChannel channel;
        private LogEntry entry;

        public LogCursor(ReadableVersionableLogChannel channel) {
            this.channel = channel;
        }

        @Override
        public LogEntry get() {
            return this.entry;
        }

        @Override
        public boolean next() throws IOException {
            this.entry = LogDeserializer.this.logEntryReader.readLogEntry(this.channel);
            return this.entry != null;
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

