/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;

public class LogFileRecoverer
implements Visitor<ReadableVersionableLogChannel, IOException> {
    private final LogEntryReader<ReadableVersionableLogChannel> logEntryReader;
    private final Visitor<CommittedTransactionRepresentation, IOException> visitor;

    public LogFileRecoverer(LogEntryReader<ReadableVersionableLogChannel> logEntryReader, Visitor<CommittedTransactionRepresentation, IOException> visitor) {
        this.logEntryReader = logEntryReader;
        this.visitor = visitor;
    }

    @Override
    public boolean visit(ReadableVersionableLogChannel channel) throws IOException {
        PhysicalTransactionCursor<ReadableVersionableLogChannel> physicalTransactionCursor = new PhysicalTransactionCursor<ReadableVersionableLogChannel>(channel, this.logEntryReader);
        while (physicalTransactionCursor.next() && !this.visitor.visit(physicalTransactionCursor.get())) {
        }
        if (this.visitor instanceof Closeable) {
            ((Closeable)((Object)this.visitor)).close();
        }
        return true;
    }
}

