/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;

public class PhysicalTransactionCursor<T extends ReadableLogChannel>
implements IOCursor<CommittedTransactionRepresentation> {
    private final T channel;
    private final LogEntryReader<T> entryReader;
    private CommittedTransactionRepresentation current;

    public PhysicalTransactionCursor(T channel, LogEntryReader<T> entryReader) {
        this.channel = channel;
        this.entryReader = entryReader;
    }

    protected List<Command> commandList() {
        return new ArrayList<Command>();
    }

    @Override
    public CommittedTransactionRepresentation get() {
        return this.current;
    }

    @Override
    public boolean next() throws IOException {
        LogEntry entry = this.entryReader.readLogEntry(this.channel);
        if (entry == null) {
            return false;
        }
        assert (entry instanceof LogEntryStart) : "Expected Start entry, read " + entry + " instead";
        LogEntryStart startEntry = (LogEntryStart)entry;
        List<Command> entries = this.commandList();
        while (true) {
            if ((entry = this.entryReader.readLogEntry(this.channel)) == null) {
                return false;
            }
            if (entry instanceof LogEntryCommit) break;
            entries.add(((LogEntryCommand)entry.as()).getXaCommand());
        }
        LogEntryCommit commitEntry = (LogEntryCommit)entry.as();
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(entries);
        transaction.setHeader(startEntry.getAdditionalHeader(), startEntry.getMasterId(), startEntry.getLocalId(), startEntry.getTimeWritten(), startEntry.getLastCommittedTxWhenTransactionStarted(), commitEntry.getTimeWritten(), -1);
        this.current = new CommittedTransactionRepresentation(startEntry, transaction, commitEntry);
        return true;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

