/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class ArrayQueueOutOfOrderSequence
implements OutOfOrderSequence {
    private volatile long highestGapFreeNumber;
    private final SortedArray outOfOrderQueue;

    public ArrayQueueOutOfOrderSequence(long startingNumber, int initialArraySize) {
        this.highestGapFreeNumber = startingNumber;
        this.outOfOrderQueue = new SortedArray(initialArraySize);
    }

    @Override
    public synchronized void offer(long number) {
        if (this.highestGapFreeNumber + 1L == number) {
            this.highestGapFreeNumber = this.outOfOrderQueue.pollHighestGapFree(number);
        } else {
            this.outOfOrderQueue.offer(this.highestGapFreeNumber, number);
        }
    }

    @Override
    public long get() {
        return this.highestGapFreeNumber;
    }

    @Override
    public synchronized void set(long number) {
        this.highestGapFreeNumber = number;
        this.outOfOrderQueue.clear();
    }

    public synchronized String toString() {
        return String.format("out-of-order-sequence:%d [%s]", this.highestGapFreeNumber, this.outOfOrderQueue);
    }

    private static class SortedArray {
        private static final long UNSET = -1L;
        private long[] array;
        private int cursor;
        private int length;

        public SortedArray(int initialArraySize) {
            this.array = new long[initialArraySize];
        }

        public void clear() {
            this.cursor = 0;
            this.length = 0;
        }

        void offer(long baseNumber, long number) {
            int diff = (int)(number - baseNumber);
            this.ensureArrayCapacity(diff);
            int index = this.cursor + diff - 1;
            for (int i = this.cursor + this.length; i < index; ++i) {
                this.array[i % this.array.length] = -1L;
            }
            this.array[index % this.array.length] = number;
            this.length = Math.max(this.length, diff);
        }

        long pollHighestGapFree(long given) {
            int index;
            long number = given;
            int length = this.length - 1;
            for (int i = 0; i < length && this.array[index = this.advanceCursor()] != -1L; ++i) {
                assert (this.array[index] == ++number) : "Expected index " + index + " to be " + number + ", but was " + this.array[index] + ". This is for i=" + i;
            }
            return number;
        }

        private int advanceCursor() {
            this.cursor = (this.cursor + 1) % this.array.length;
            --this.length;
            assert (this.length >= 0);
            return this.cursor;
        }

        private void ensureArrayCapacity(int capacity) {
            while (capacity > this.array.length) {
                long[] newArray = new long[this.array.length * 2];
                for (int i = 0; i < this.length; ++i) {
                    newArray[i] = this.array[(this.cursor + i) % this.array.length];
                }
                this.array = newArray;
                this.cursor = 0;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.length; ++i) {
                long value = this.array[(this.cursor + i) % this.array.length];
                if (value == -1L) continue;
                builder.append(builder.length() > 0 ? "," : "").append(value);
            }
            return builder.toString();
        }
    }
}

