/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import org.neo4j.function.Function;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStep;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStep;
import org.neo4j.unsafe.impl.batchimport.NodeEncoderStep;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStep;
import org.neo4j.unsafe.impl.batchimport.WriterFactories;
import org.neo4j.unsafe.impl.batchimport.cache.LongArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLinkImpl;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapping;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.IteratorBatcherStep;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStore;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ParallelBatchImporter
implements BatchImporter {
    private final String storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final IoMonitor writeMonitor;
    private final ExecutionMonitor executionMonitor;
    private final Logging logging;
    private final StringLogger logger;
    private final Monitors monitors;
    private final BatchingPageCache.WriterFactory writerFactory;
    private final AdditionalInitialIds highTokenIds;

    public ParallelBatchImporter(String storeDir, FileSystemAbstraction fileSystem, Configuration config, Logging logging, ExecutionMonitor executionMonitor, Function<Configuration, BatchingPageCache.WriterFactory> writerFactory, AdditionalInitialIds highTokenIds) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logging = logging;
        this.highTokenIds = highTokenIds;
        this.logger = logging.getMessagesLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.monitors = new Monitors();
        this.writeMonitor = new IoMonitor();
        this.writerFactory = (BatchingPageCache.WriterFactory)writerFactory.apply((Object)config);
    }

    public ParallelBatchImporter(String storeDir, Configuration config, Logging logging, ExecutionMonitor executionMonitor) {
        this(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), config, logging, executionMonitor, WriterFactories.parallel(), AdditionalInitialIds.EMPTY);
    }

    @Override
    public void doImport(Input input) throws IOException {
        this.logger.info("Import starting");
        long startTime = System.currentTimeMillis();
        try (BatchingNeoStore neoStore = new BatchingNeoStore(this.fileSystem, this.storeDir, this.config, this.writeMonitor, this.logging, this.monitors, this.writerFactory, this.highTokenIds);){
            IdMapping idMapping = input.idMapping();
            IdMapper idMapper = idMapping.idMapper();
            IdGenerator idGenerator = idMapping.idGenerator();
            NodeRelationshipLinkImpl nodeRelationshipLink = new NodeRelationshipLinkImpl(LongArrayFactory.AUTO, this.config.denseNodeThreshold());
            ResourceIterable<InputNode> nodes = input.nodes();
            ResourceIterable<InputRelationship> relationships = input.relationships();
            NodeStage nodeStage = new NodeStage(nodes, idMapper, idGenerator, neoStore);
            CalculateDenseNodesStage calculateDenseNodesStage = new CalculateDenseNodesStage(relationships, nodeRelationshipLink, idMapper);
            if (idMapper.needsPreparation()) {
                this.executeStages(nodeStage);
                this.executeStages(calculateDenseNodesStage);
            } else {
                this.executeStages(nodeStage, calculateDenseNodesStage);
            }
            RelationshipStage relationshipStage = new RelationshipStage(relationships, idMapper, neoStore, nodeRelationshipLink);
            this.executeStages(relationshipStage);
            this.writerFactory.awaitEverythingWritten();
            neoStore.switchToUpdateMode();
            idMapper = null;
            idGenerator = null;
            NodeFirstRelationshipStage nodeFirstRelationshipStage = new NodeFirstRelationshipStage(neoStore, nodeRelationshipLink);
            this.executeStages(nodeFirstRelationshipStage);
            nodeRelationshipLink.clearRelationships();
            RelationshipLinkbackStage relationshipLinkbackStage = new RelationshipLinkbackStage(neoStore, nodeRelationshipLink);
            this.executeStages(relationshipLinkbackStage);
            nodeRelationshipLink = null;
            NodeLabelsCache countsCache = new NodeLabelsCache(LongArrayFactory.AUTO, neoStore.getLabelRepository().getHighId());
            NodeCountsStage nodeCountsStage = new NodeCountsStage(neoStore, countsCache);
            this.executeStages(nodeCountsStage);
            RelationshipCountsStage relationshipCountsStage = new RelationshipCountsStage(neoStore, countsCache);
            this.executeStages(relationshipCountsStage);
            this.executionMonitor.done(System.currentTimeMillis() - startTime);
        }
        catch (Throwable t) {
            this.logger.error("Error during import", t);
            throw Exceptions.launderedException(IOException.class, t);
        }
        finally {
            this.writerFactory.shutdown();
        }
        this.logger.info("Import completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeStages(Stage ... stages) {
        try {
            StageExecution[] executions = new StageExecution[stages.length];
            for (int i = 0; i < stages.length; ++i) {
                executions[i] = stages[i].execute();
            }
            this.executionMonitor.monitor(executions);
        }
        finally {
            for (Stage stage : stages) {
                stage.close();
            }
        }
    }

    public class RelationshipCountsStage
    extends Stage {
        public RelationshipCountsStage(BatchingNeoStore neoStore, NodeLabelsCache cache) {
            super("Relationship counts", ParallelBatchImporter.this.config);
            this.add(new RelationshipCountsStep(this.control(), ParallelBatchImporter.this.config.batchSize(), neoStore.getRelationshipStore(), cache, neoStore.getLabelRepository().getHighId(), neoStore.getRelationshipTypeRepository().getHighId(), neoStore.getCountsStore()));
        }
    }

    public class NodeCountsStage
    extends Stage {
        public NodeCountsStage(BatchingNeoStore neoStore, NodeLabelsCache cache) {
            super("Node counts", ParallelBatchImporter.this.config);
            this.add(new NodeCountsStep(this.control(), ParallelBatchImporter.this.config.batchSize(), neoStore.getNodeStore(), cache, neoStore.getLabelRepository().getHighId(), neoStore.getCountsStore()));
        }
    }

    public class RelationshipLinkbackStage
    extends Stage {
        public RelationshipLinkbackStage(BatchingNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super("Relationship back link", ParallelBatchImporter.this.config);
            this.add(new RelationshipLinkbackStep(this.control(), ParallelBatchImporter.this.config.batchSize(), neoStore.getRelationshipStore(), nodeRelationshipLink));
        }
    }

    public class NodeFirstRelationshipStage
    extends Stage {
        public NodeFirstRelationshipStage(BatchingNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super("Node first rel", ParallelBatchImporter.this.config);
            this.add(new NodeFirstRelationshipStep(this.control(), ParallelBatchImporter.this.config.batchSize(), neoStore.getNodeStore(), neoStore.getRelationshipGroupStore(), nodeRelationshipLink));
        }
    }

    public class RelationshipStage
    extends Stage {
        public RelationshipStage(ResourceIterable<InputRelationship> relationships, IdMapper idMapper, BatchingNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super("Relationships", ParallelBatchImporter.this.config);
            this.add(new IteratorBatcherStep<InputRelationship>(this.control(), "INPUT", ParallelBatchImporter.this.config.batchSize(), relationships.iterator()));
            RelationshipStore relationshipStore = neoStore.getRelationshipStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            this.add(new RelationshipEncoderStep(this.control(), "ENCODER", ParallelBatchImporter.this.config.workAheadSize(), 1, idMapper, neoStore.getPropertyKeyRepository(), neoStore.getRelationshipTypeRepository(), relationshipStore, propertyStore, nodeRelationshipLink));
            this.add(new EntityStoreUpdaterStep<RelationshipRecord>(this.control(), "WRITER", relationshipStore, propertyStore, ParallelBatchImporter.this.writeMonitor));
        }
    }

    public class CalculateDenseNodesStage
    extends Stage {
        public CalculateDenseNodesStage(ResourceIterable<InputRelationship> relationships, NodeRelationshipLink nodeRelationshipLink, IdMapper idMapper) {
            super("Calculate dense nodes", ParallelBatchImporter.this.config);
            this.add(new IteratorBatcherStep<InputRelationship>(this.control(), "INPUT", ParallelBatchImporter.this.config.batchSize(), relationships.iterator()));
            this.add(new CalculateDenseNodesStep(this.control(), ParallelBatchImporter.this.config.workAheadSize(), nodeRelationshipLink, idMapper, ParallelBatchImporter.this.logger));
        }
    }

    public class NodeStage
    extends Stage {
        public NodeStage(ResourceIterable<InputNode> nodes, IdMapper idMapper, IdGenerator idGenerator, BatchingNeoStore neoStore) {
            super("Nodes", ParallelBatchImporter.this.config);
            this.add(new IteratorBatcherStep<InputNode>(this.control(), "INPUT", ParallelBatchImporter.this.config.batchSize(), nodes.iterator()));
            NodeStore nodeStore = neoStore.getNodeStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            IterableWrapper<Object, InputNode> allIds = new IterableWrapper<Object, InputNode>(nodes){

                @Override
                protected Object underlyingObjectToObject(InputNode object) {
                    return object.id();
                }
            };
            this.add(new NodeEncoderStep(this.control(), "ENCODER", ParallelBatchImporter.this.config.workAheadSize(), 1, idMapper, idGenerator, neoStore.getPropertyKeyRepository(), neoStore.getLabelRepository(), nodeStore, propertyStore, (Iterable<Object>)allIds));
            this.add(new EntityStoreUpdaterStep<NodeRecord>(this.control(), "WRITER", nodeStore, propertyStore, ParallelBatchImporter.this.writeMonitor));
        }
    }
}

