/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.RelationshipStoreProcessorStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class RelationshipCountsStep
extends RelationshipStoreProcessorStep {
    private static final boolean COMPUTE_DOUBLE_SIDED_RELATIONSHIP_COUNTS = false;
    private final NodeLabelsCache nodeLabelCache;
    private final long[][][] counts;
    private int[] startScratch = new int[20];
    private int[] endScratch = new int[20];
    private final CountsTracker countsTracker;
    private final int anyLabel;
    private final int anyRelationshipType;

    protected RelationshipCountsStep(StageControl control, int batchSize, RelationshipStore relationshipStore, NodeLabelsCache nodeLabelCache, int highLabelId, int highRelationshipTypeId, CountsTracker countsTracker) {
        super(control, "RELATIONSHIP COUNTS", batchSize, relationshipStore);
        this.nodeLabelCache = nodeLabelCache;
        this.countsTracker = countsTracker;
        this.counts = new long[highLabelId + 1][highRelationshipTypeId + 1][highLabelId + 1];
        this.anyLabel = highLabelId;
        this.anyRelationshipType = highRelationshipTypeId;
    }

    @Override
    protected boolean process(RelationshipRecord record) {
        long startNode = record.getFirstNode();
        long endNode = record.getSecondNode();
        int type = record.getType();
        long[] lArray = this.counts[this.anyLabel][this.anyRelationshipType];
        int n = this.anyLabel;
        lArray[n] = lArray[n] + 1L;
        long[] lArray2 = this.counts[this.anyLabel][type];
        int n2 = this.anyLabel;
        lArray2[n2] = lArray2[n2] + 1L;
        for (int startNodeLabelId : this.startScratch = this.nodeLabelCache.get(startNode, this.startScratch)) {
            if (startNodeLabelId == -1) break;
            long[] lArray3 = this.counts[startNodeLabelId][this.anyRelationshipType];
            int n3 = this.anyLabel;
            lArray3[n3] = lArray3[n3] + 1L;
            long[] lArray4 = this.counts[startNodeLabelId][type];
            int n4 = this.anyLabel;
            lArray4[n4] = lArray4[n4] + 1L;
            for (int endNodeLabelId : this.endScratch = this.nodeLabelCache.get(endNode, this.endScratch)) {
                if (endNodeLabelId == -1) break;
                long[] lArray5 = this.counts[startNodeLabelId][this.anyRelationshipType];
                int n5 = endNodeLabelId;
                lArray5[n5] = lArray5[n5] + 1L;
                long[] lArray6 = this.counts[startNodeLabelId][type];
                int n6 = endNodeLabelId;
                lArray6[n6] = lArray6[n6] + 1L;
            }
        }
        this.endScratch = this.nodeLabelCache.get(endNode, this.endScratch);
        for (int endNodeLabelId : this.endScratch) {
            if (endNodeLabelId == -1) break;
            long[] lArray7 = this.counts[this.anyLabel][this.anyRelationshipType];
            int n7 = endNodeLabelId;
            lArray7[n7] = lArray7[n7] + 1L;
            long[] lArray8 = this.counts[this.anyLabel][type];
            int n8 = endNodeLabelId;
            lArray8[n8] = lArray8[n8] + 1L;
        }
        return false;
    }

    @Override
    protected void done() {
        for (int startNodeLabelId = 0; startNodeLabelId < this.counts.length; ++startNodeLabelId) {
            long[][] types = this.counts[startNodeLabelId];
            for (int typeId = 0; typeId < types.length; ++typeId) {
                long[] endNodeLabelIds = types[typeId];
                for (int endNodeLabelId = 0; endNodeLabelId < endNodeLabelIds.length; ++endNodeLabelId) {
                    if (startNodeLabelId != this.anyLabel && endNodeLabelId != this.anyLabel) continue;
                    int startLabel = startNodeLabelId == this.anyLabel ? -1 : startNodeLabelId;
                    int type = typeId == this.anyRelationshipType ? -1 : typeId;
                    int endLabel = endNodeLabelId == this.anyLabel ? -1 : endNodeLabelId;
                    long count = endNodeLabelIds[endNodeLabelId];
                    this.countsTracker.incrementRelationshipCount(startLabel, type, endLabel, count);
                }
            }
        }
    }
}

