/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Iterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class Utils {
    public static Iterator<PropertyBlock> propertyKeysAndValues(final Object[] properties, final BatchingTokenRepository<?> propertyKeyHolder, final PropertyCreator creator) {
        return new PrefetchingIterator<PropertyBlock>(){
            private int cursor;

            @Override
            protected PropertyBlock fetchNextOrNull() {
                if (this.cursor >= properties.length) {
                    return null;
                }
                int key = propertyKeyHolder.getOrCreateId((String)properties[this.cursor++]);
                Object value = properties[this.cursor++];
                return creator.encodeValue(new PropertyBlock(), key, value);
            }
        };
    }

    public static int safeCastLongToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (int)value;
    }

    public static short safeCastLongToShort(long value) {
        if (value > 32767L) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (short)value;
    }

    public static byte safeCastLongToByte(long value) {
        if (value > 127L) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (byte)value;
    }

    public static boolean unsignedCompare(long dataA, long dataB, CompareType compareType) {
        switch (compareType) {
            case EQ: {
                return dataA == dataB;
            }
            case GE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case GT: {
                return !(dataA < dataB ^ dataA < 0L != dataB < 0L);
            }
            case LE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case LT: {
                return dataA < dataB ^ dataA < 0L != dataB < 0L;
            }
        }
        return false;
    }

    private Utils() {
    }

    public static enum CompareType {
        EQ,
        GT,
        GE,
        LT,
        LE,
        NE;

    }
}

