/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.helpers.Pair;

public abstract class InputEntity {
    public static final Object[] NO_PROPERTIES = new Object[0];
    public static final String[] NO_LABELS = new String[0];
    private final Object[] properties;
    private final Long firstPropertyId;

    public InputEntity(Object[] properties, Long firstPropertyId) {
        this.properties = properties;
        this.firstPropertyId = firstPropertyId;
    }

    public Object[] properties() {
        return this.properties;
    }

    public boolean hasFirstPropertyId() {
        return this.firstPropertyId != null;
    }

    public long firstPropertyId() {
        return this.firstPropertyId;
    }

    public String toString() {
        ArrayList fields = new ArrayList();
        this.toStringFields(fields);
        StringBuilder builder = new StringBuilder("%s:");
        Object[] arguments = new Object[fields.size() + 1];
        int cursor = 0;
        arguments[cursor++] = this.getClass().getSimpleName();
        for (Pair pair : fields) {
            builder.append("%n   %s");
            arguments[cursor++] = (String)pair.first() + ": " + pair.other();
        }
        return String.format(builder.toString(), arguments);
    }

    protected void toStringFields(Collection<Pair<String, ?>> fields) {
        if (this.hasFirstPropertyId()) {
            fields.add(Pair.of("nextProp", this.firstPropertyId));
        } else {
            fields.add(Pair.of("properties", Arrays.toString(this.properties)));
        }
    }
}

