/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.File;
import org.neo4j.function.Functions;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapping;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;

public class Inputs {
    public static Input input(Iterable<InputNode> nodes, Iterable<InputRelationship> relationships, final IdMapping idMapping) {
        final ResourceIterable<InputNode> resourceNodes = Iterables.asResourceIterable(nodes);
        final ResourceIterable<InputRelationship> resourceRelationships = Iterables.asResourceIterable(relationships);
        return new Input(){

            @Override
            public ResourceIterable<InputRelationship> relationships() {
                return resourceRelationships;
            }

            @Override
            public ResourceIterable<InputNode> nodes() {
                return resourceNodes;
            }

            @Override
            public IdMapping idMapping() {
                return idMapping;
            }
        };
    }

    public static Input csv(File nodes, File relationships, IdType idType, Configuration configuration) {
        Iterable<DataFactory<InputNode>> nodeData = Iterables.iterable(DataFactories.data(Functions.identity(), nodes));
        Iterable<DataFactory<InputRelationship>> relationshipData = Iterables.iterable(DataFactories.data(Functions.identity(), relationships));
        return new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(), relationshipData, DataFactories.defaultFormatRelationshipFileHeader(), idType, configuration);
    }
}

