/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInsertDocTest {
    @Rule
    public EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private EphemeralFileSystemAbstraction fileSystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void insert() throws InterruptedException {
        BatchInserter inserter = BatchInserters.inserter((String)new File("target/batchinserter-example").getAbsolutePath(), (FileSystemAbstraction)this.fileSystem);
        Label personLabel = DynamicLabel.label((String)"Person");
        inserter.createDeferredSchemaIndex(personLabel).on("name").create();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", "Mattias");
        long mattiasNode = inserter.createNode(properties, new Label[]{personLabel});
        properties.put("name", "Chris");
        long chrisNode = inserter.createNode(properties, new Label[]{personLabel});
        DynamicRelationshipType knows = DynamicRelationshipType.withName((String)"KNOWS");
        inserter.createRelationship(mattiasNode, chrisNode, (RelationshipType)knows, null);
        inserter.shutdown();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fileSystem).newImpermanentDatabase(new File("target/batchinserter-example").getAbsolutePath());
        try (Transaction tx = db.beginTx();){
            Node mNode = db.getNodeById(mattiasNode);
            Node cNode = mNode.getSingleRelationship((RelationshipType)knows, Direction.OUTGOING).getEndNode();
            Assert.assertThat((Object)((String)cNode.getProperty("name")), (Matcher)Is.is((Object)"Chris"));
            Assert.assertThat((Object)db.schema().getIndexes(personLabel).iterator().hasNext(), (Matcher)Is.is((Object)true));
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void insertWithConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("mapped_memory_total_size", "90M");
        BatchInserter inserter = BatchInserters.inserter((String)new File("target/batchinserter-example-config").getAbsolutePath(), (FileSystemAbstraction)this.fileSystem, config);
        inserter.shutdown();
    }

    @Test
    public void insertWithConfigFile() throws IOException {
        try (Writer fw = this.fileSystem.openAsWriter(new File("target/batchinsert-config").getAbsoluteFile(), "utf-8", false);){
            fw.append("mapped_memory_total_size=3G");
        }
        var2_2 = null;
        try (InputStream input = this.fileSystem.openAsInputStream(new File("target/batchinsert-config").getAbsoluteFile());){
            Map config = MapUtil.load((InputStream)input);
            BatchInserter inserter = BatchInserters.inserter((String)"target/batchinserter-example-config", (FileSystemAbstraction)this.fileSystem, (Map)config);
            inserter.shutdown();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Before
    public void before() throws Exception {
        this.fileSystem = this.fileSystemRule.get();
        this.fileSystem.mkdirs(new File("target"));
    }
}

