/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.ImpermanentDatabaseRule;

public class SchemaAcceptanceTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private GraphDatabaseService db;
    private Label label = Labels.MY_LABEL;
    private String propertyKey = "my_property_key";

    @Test
    public void addingAnIndexingRuleShouldSucceed() throws Exception {
        IndexDefinition index = Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        MatcherAssert.assertThat(Neo4jMatchers.getIndexes(this.db, this.label), Neo4jMatchers.containsOnly(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addingAnIndexingRuleInNestedTxShouldSucceed() throws Exception {
        IndexDefinition index;
        IndexDefinition indexDef;
        Transaction tx = this.db.beginTx();
        try {
            Transaction tx1 = this.db.beginTx();
            try {
                indexDef = this.db.schema().indexFor(this.label).on(this.propertyKey).create();
                tx1.success();
            }
            finally {
                tx1.finish();
            }
            index = indexDef;
            tx.success();
        }
        finally {
            tx.finish();
        }
        Neo4jMatchers.waitForIndex(this.db, indexDef);
        MatcherAssert.assertThat(Neo4jMatchers.getIndexes(this.db, this.label), Neo4jMatchers.containsOnly(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowConstraintViolationIfAskedToIndexSamePropertyAndLabelTwiceInSameTx() throws Exception {
        Transaction tx = this.db.beginTx();
        try {
            Schema schema = this.db.schema();
            schema.indexFor(this.label).on(this.propertyKey).create();
            try {
                schema.indexFor(this.label).on(this.propertyKey).create();
                Assert.fail((String)"Should not have validated");
            }
            catch (ConstraintViolationException e) {
                Assert.assertEquals((Object)"There already exists an index for label 'MY_LABEL' on property 'my_property_key'.", (Object)e.getMessage());
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowConstraintViolationIfAskedToIndexPropertyThatIsAlreadyIndexed() throws Exception {
        Transaction tx = this.db.beginTx();
        Schema schema = this.db.schema();
        schema.indexFor(this.label).on(this.propertyKey).create();
        tx.success();
        tx.finish();
        ConstraintViolationException caught = null;
        tx = this.db.beginTx();
        try {
            schema.indexFor(this.label).on(this.propertyKey).create();
            tx.success();
        }
        catch (ConstraintViolationException e) {
            caught = e;
        }
        finally {
            tx.finish();
        }
        MatcherAssert.assertThat((Object)((Object)caught), (Matcher)IsNot.not((Matcher)IsNull.nullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowConstraintViolationIfAskedToCreateCompoundIndex() throws Exception {
        Transaction tx = this.db.beginTx();
        try {
            Schema schema = this.db.schema();
            schema.indexFor(this.label).on("my_property_key").on("other_property").create();
            tx.success();
            Assert.fail((String)"Should not be able to create index on multiple propertyKey keys");
        }
        catch (UnsupportedOperationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Compound indexes"));
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowConstraintViolationIfAskedToCreateCompoundConstraint() throws Exception {
        Transaction tx = this.db.beginTx();
        try {
            Schema schema = this.db.schema();
            schema.constraintFor(this.label).assertPropertyIsUnique("my_property_key").assertPropertyIsUnique("other_property").create();
            tx.success();
            Assert.fail((String)"Should not be able to create constraint on multiple propertyKey keys");
        }
        catch (UnsupportedOperationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"can only create one unique constraint"));
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void droppingExistingIndexRuleShouldSucceed() throws Exception {
        IndexDefinition index = Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        this.dropIndex(index);
        MatcherAssert.assertThat(Neo4jMatchers.getIndexes(this.db, this.label), Neo4jMatchers.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void droppingAnUnexistingIndexShouldGiveHelpfulExceptionInSameTransaction() throws Exception {
        IndexDefinition index = Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        Transaction tx = this.db.beginTx();
        try {
            index.drop();
            try {
                index.drop();
                Assert.fail((String)"Should not be able to drop index twice");
            }
            catch (ConstraintViolationException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unable to drop index"));
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        MatcherAssert.assertThat((String)"Index should have been deleted", Neo4jMatchers.getIndexes(this.db, this.label), (Matcher)IsNot.not(Neo4jMatchers.contains(index)));
    }

    @Test
    public void droppingAnUnexistingIndexShouldGiveHelpfulExceptionInSeparateTransactions() throws Exception {
        IndexDefinition index = Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        this.dropIndex(index);
        try {
            this.dropIndex(index);
            Assert.fail((String)"Should not be able to drop index twice");
        }
        catch (ConstraintViolationException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unable to drop index"));
        }
        MatcherAssert.assertThat((String)"Index should have been deleted", Neo4jMatchers.getIndexes(this.db, this.label), (Matcher)IsNot.not(Neo4jMatchers.contains(index)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void awaitingIndexComingOnlineWorks() {
        IndexDefinition index = Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        Transaction tx = this.db.beginTx();
        try {
            this.db.schema().awaitIndexOnline(index, 1L, TimeUnit.MINUTES);
            Assert.assertEquals((Object)Schema.IndexState.ONLINE, (Object)this.db.schema().getIndexState(index));
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void awaitingAllIndexesComingOnlineWorks() {
        IndexDefinition index = Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        Neo4jMatchers.createIndex(this.db, this.label, "other_property");
        Neo4jMatchers.waitForIndex(this.db, index);
        Transaction tx = this.db.beginTx();
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Assert.assertEquals((Object)Schema.IndexState.ONLINE, (Object)this.db.schema().getIndexState(index));
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void shouldRecreateDroppedIndex() throws Exception {
        Node node = this.createNode(this.db, this.propertyKey, "Neo", this.label);
        IndexDefinition index = Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        Neo4jMatchers.waitForIndex(this.db, index);
        this.dropIndex(index);
        Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        Neo4jMatchers.waitForIndex(this.db, index);
        MatcherAssert.assertThat(Neo4jMatchers.getIndexes(this.db, this.label), Neo4jMatchers.contains(index));
        MatcherAssert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.label, this.propertyKey, "Neo", this.db), Neo4jMatchers.containsOnly(node));
    }

    @Test
    public void shouldCreateUniquenessConstraint() throws Exception {
        ConstraintDefinition constraint = this.createConstraint(this.label, this.propertyKey);
        try (Transaction tx = this.db.beginTx();){
            Assert.assertEquals((Object)ConstraintType.UNIQUENESS, (Object)constraint.getConstraintType());
            Assert.assertEquals((Object)this.label.name(), (Object)constraint.getLabel().name());
            Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{this.propertyKey}), (Object)IteratorUtil.asSet((Iterable)constraint.getPropertyKeys()));
            tx.success();
        }
    }

    @Test
    public void shouldListAddedConstraintsByLabel() throws Exception {
        ConstraintDefinition createdConstraint = this.createConstraint(this.label, this.propertyKey);
        MatcherAssert.assertThat(Neo4jMatchers.getConstraints(this.db, this.label), Neo4jMatchers.containsOnly(createdConstraint));
    }

    @Test
    public void shouldListAddedConstraints() throws Exception {
        ConstraintDefinition createdConstraint = this.createConstraint(this.label, this.propertyKey);
        MatcherAssert.assertThat(Neo4jMatchers.getConstraints(this.db), Neo4jMatchers.containsOnly(createdConstraint));
    }

    @Test
    public void shouldDropUniquenessConstraint() throws Exception {
        ConstraintDefinition constraint = this.createConstraint(this.label, this.propertyKey);
        this.dropConstraint(this.db, constraint);
        MatcherAssert.assertThat(Neo4jMatchers.getConstraints(this.db, this.label), Neo4jMatchers.isEmpty());
    }

    @Test
    public void addingConstraintWhenIndexAlreadyExistsGivesNiceError() throws Exception {
        Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        try {
            this.createConstraint(this.label, this.propertyKey);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((Object)String.format("There already exists an index for label 'MY_LABEL' on property 'my_property_key'. A constraint cannot be created until the index has been dropped.", new Object[0]), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addingUniquenessConstraintWhenDuplicateDataExistsGivesNiceError() throws Exception {
        Transaction transaction = this.db.beginTx();
        try {
            this.db.createNode(new Label[]{this.label}).setProperty(this.propertyKey, (Object)"value1");
            this.db.createNode(new Label[]{this.label}).setProperty(this.propertyKey, (Object)"value1");
            transaction.success();
        }
        finally {
            transaction.finish();
        }
        try {
            this.createConstraint(this.label, this.propertyKey);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((Object)String.format("Unable to create CONSTRAINT ON ( my_label:MY_LABEL ) ASSERT my_label.my_property_key IS UNIQUE:%nMultiple nodes with label `MY_LABEL` have property `my_property_key` = 'value1':%n  node(0)%n  node(1)", new Object[0]), (Object)e.getMessage());
        }
    }

    @Test
    public void addingConstraintWhenAlreadyConstrainedGivesNiceError() throws Exception {
        this.createConstraint(this.label, this.propertyKey);
        try {
            this.createConstraint(this.label, this.propertyKey);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((Object)"Label 'MY_LABEL' and property 'my_property_key' already have a unique constraint defined on them.", (Object)e.getMessage());
        }
    }

    @Test
    public void addingIndexWhenAlreadyConstrained() throws Exception {
        this.createConstraint(this.label, this.propertyKey);
        try {
            Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((Object)"Label 'MY_LABEL' and property 'my_property_key' have a unique constraint defined on them, so an index is already created that matches this.", (Object)e.getMessage());
        }
    }

    @Test
    public void addingIndexWhenAlreadyIndexed() throws Exception {
        Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
        try {
            Neo4jMatchers.createIndex(this.db, this.label, this.propertyKey);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (ConstraintViolationException e) {
            Assert.assertEquals((Object)"There already exists an index for label 'MY_LABEL' on property 'my_property_key'.", (Object)e.getMessage());
        }
    }

    @Test
    public void addedUncommittedIndexesShouldBeVisibleWithinTheTransaction() {
        IndexDefinition indexA = Neo4jMatchers.createIndex(this.db, this.label, "a");
        this.createConstraint(this.label, "b");
        try (Transaction tx = this.db.beginTx();){
            MatcherAssert.assertThat((Object)Iterables.count((Iterable)this.db.schema().getIndexes(this.label)), (Matcher)Matchers.is((Object)2L));
            IndexDefinition indexC = this.db.schema().indexFor(this.label).on("c").create();
            MatcherAssert.assertThat((Object)Iterables.count((Iterable)this.db.schema().getIndexes(this.label)), (Matcher)Matchers.is((Object)3L));
            MatcherAssert.assertThat((Object)this.db.schema().getIndexState(indexA), (Matcher)Matchers.is((Object)Schema.IndexState.ONLINE));
            MatcherAssert.assertThat((Object)this.db.schema().getIndexState(indexC), (Matcher)Matchers.is((Object)Schema.IndexState.POPULATING));
        }
    }

    @Before
    public void init() {
        this.db = this.dbRule.getGraphDatabaseService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropConstraint(GraphDatabaseService db, ConstraintDefinition constraint) {
        Transaction tx = db.beginTx();
        try {
            constraint.drop();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstraintDefinition createConstraint(Label label, String prop) {
        Transaction tx = this.db.beginTx();
        try {
            ConstraintDefinition constraint = this.db.schema().constraintFor(label).assertPropertyIsUnique(prop).create();
            tx.success();
            ConstraintDefinition constraintDefinition = constraint;
            return constraintDefinition;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndex(IndexDefinition index) {
        Transaction tx = this.db.beginTx();
        try {
            index.drop();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNode(GraphDatabaseService db, String key, Object value, Label label) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode(new Label[]{label});
            node.setProperty(key, value);
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    private static enum Labels implements Label
    {
        MY_LABEL,
        MY_OTHER_LABEL;

    }
}

