/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.SoftCacheProvider;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TestGraphDatabaseFactory;

public class SetCacheProvidersTest {
    @Test
    public void testSetNoCache() {
        ArrayList cacheList = new ArrayList();
        TestGraphDatabaseFactory gdbf = new TestGraphDatabaseFactory();
        gdbf.setCacheProviders(cacheList);
        try {
            gdbf.newImpermanentDatabase();
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().contains("No provider for cache type"));
            Assert.assertTrue((boolean)iae.getMessage().contains("register"));
            Assert.assertTrue((boolean)iae.getMessage().contains("missing"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetSoftRefCache() {
        ArrayList<CapturingCacheProvider> cacheList = new ArrayList<CapturingCacheProvider>();
        TestGraphDatabaseFactory gdbf = new TestGraphDatabaseFactory();
        SoftCacheProvider cacheProvider = new SoftCacheProvider();
        CapturingCacheProvider capturingProvider = new CapturingCacheProvider((CacheProvider)cacheProvider);
        cacheList.add(capturingProvider);
        gdbf.setCacheProviders(cacheList);
        GraphDatabaseAPI db = (GraphDatabaseAPI)gdbf.newImpermanentDatabase();
        try {
            Assert.assertTrue((boolean)capturingProvider.nodeCacheCalled);
            Assert.assertTrue((boolean)capturingProvider.relCacheCalled);
        }
        finally {
            db.shutdown();
        }
    }

    public class CapturingCacheProvider
    extends CacheProvider {
        private final CacheProvider cacheProvider;
        private boolean nodeCacheCalled;
        private boolean relCacheCalled;

        public CapturingCacheProvider(CacheProvider cacheProvider) {
            super(cacheProvider.getName(), cacheProvider.getDescription());
            this.cacheProvider = cacheProvider;
        }

        public Cache<NodeImpl> newNodeCache(StringLogger logger, Config config, Monitors monitors) {
            this.nodeCacheCalled = true;
            return this.cacheProvider.newNodeCache(logger, config, monitors);
        }

        public Cache<RelationshipImpl> newRelationshipCache(StringLogger logger, Config config, Monitors monitors) {
            this.relCacheCalled = true;
            return this.cacheProvider.newRelationshipCache(logger, config, monitors);
        }
    }
}

