/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import org.neo4j.graphdb.mockfs.FileSystemGuard;
import org.neo4j.io.fs.StoreChannel;

public class BreakableFileChannel
implements StoreChannel {
    private final StoreChannel inner;
    private final File theFile;
    private FileSystemGuard fs;
    private int bytesWritten = 0;

    public BreakableFileChannel(StoreChannel open, File theFile, FileSystemGuard guard) {
        this.inner = open;
        this.theFile = theFile;
        this.fs = guard;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.inner.read(byteBuffer);
    }

    public long read(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        return this.inner.read(byteBuffers, i, i1);
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.inner.read(dsts);
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.inner.write(byteBuffer);
    }

    public long write(ByteBuffer[] byteBuffers, int i, int i1) throws IOException {
        return this.inner.write(byteBuffers, i, i1);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.inner.write(srcs);
    }

    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.inner.writeAll(src, position);
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.inner.writeAll(src);
    }

    public long position() throws IOException {
        return this.inner.position();
    }

    public BreakableFileChannel position(long l) throws IOException {
        this.inner.position(l);
        return this;
    }

    public long size() throws IOException {
        return this.inner.size();
    }

    public BreakableFileChannel truncate(long l) throws IOException {
        this.inner.truncate(l);
        return this;
    }

    public void force(boolean b) throws IOException {
        this.inner.force(b);
    }

    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        return this.inner.read(byteBuffer, l);
    }

    public FileLock tryLock() throws IOException {
        return this.inner.tryLock();
    }

    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        int writtenInThisCall = 0;
        for (int i = 0; i < byteBuffer.limit(); ++i) {
            this.fs.checkOperation(FileSystemGuard.OperationType.WRITE, this.theFile, this.bytesWritten, 1, this.inner.position());
            ByteBuffer toWrite = byteBuffer.slice();
            toWrite.limit(1);
            this.inner.write(toWrite, l + (long)writtenInThisCall);
            byteBuffer.get();
            ++this.bytesWritten;
            ++writtenInThisCall;
        }
        return writtenInThisCall;
    }

    public boolean isOpen() {
        return this.inner.isOpen();
    }

    public void close() throws IOException {
        this.inner.close();
    }
}

