/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.IteratorUtil;

public class ArrayUtilTest {
    @Test
    public void shouldProduceUnionOfTwoArrays() throws Exception {
        Object[] first = new String[]{"one", "three"};
        Object[] other = new String[]{"two", "four", "five"};
        Object[] union = (String[])ArrayUtil.union((Object[])first, (Object[])other);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"one", "two", "three", "four", "five"}), (Object)IteratorUtil.asSet((Object[])union));
    }

    @Test
    public void shouldProduceUnionWhereFirstIsNull() throws Exception {
        Object[] first = null;
        Object[] other = new String[]{"one", "two"};
        Object[] union = (String[])ArrayUtil.union(first, (Object[])other);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"one", "two"}), (Object)IteratorUtil.asSet((Object[])union));
    }

    @Test
    public void shouldProduceUnionWhereOtherIsNull() throws Exception {
        Object[] first = new String[]{"one", "two"};
        Object[] other = null;
        Object[] union = (String[])ArrayUtil.union((Object[])first, other);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{"one", "two"}), (Object)IteratorUtil.asSet((Object[])union));
    }

    @Test
    public void shouldCheckNullSafeEqual() throws Exception {
        Assert.assertTrue((boolean)ArrayUtil.nullSafeEquals(null, null));
        Assert.assertFalse((boolean)ArrayUtil.nullSafeEquals((Object)"1", null));
        Assert.assertFalse((boolean)ArrayUtil.nullSafeEquals(null, (Object)"1"));
        Assert.assertTrue((boolean)ArrayUtil.nullSafeEquals((Object)"1", (Object)"1"));
    }

    @Test
    public void shouldConcatOneAndMany() throws Exception {
        Integer[] result = (Integer[])ArrayUtil.concat((Object)0, (Object[])new Integer[]{1, 2, 3, 4});
        for (int i = 0; i < result.length; ++i) {
            Assert.assertEquals((Object)i, (Object)result[i]);
        }
    }
}

