/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.CombiningResourceIterator;
import org.neo4j.helpers.collection.IteratorUtil;

public class CombiningResourceIteratorTest {
    @Test
    public void shouldNotCloseDuringIteration() throws Exception {
        ResourceIterator it1 = (ResourceIterator)Mockito.spy((Object)IteratorUtil.asResourceIterator((Iterator)IteratorUtil.iterator((Object[])new Long[]{1L, 2L, 3L})));
        ResourceIterator it2 = (ResourceIterator)Mockito.spy((Object)IteratorUtil.asResourceIterator((Iterator)IteratorUtil.iterator((Object[])new Long[]{5L, 6L, 7L})));
        CombiningResourceIterator combingIterator = new CombiningResourceIterator(IteratorUtil.iterator((Object[])new ResourceIterator[]{it1, it2}));
        MatcherAssert.assertThat((Object)IteratorUtil.asList((Iterator)combingIterator), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L, 3L, 5L, 6L, 7L)));
        ((ResourceIterator)Mockito.verify((Object)it1, (VerificationMode)Mockito.never())).close();
        ((ResourceIterator)Mockito.verify((Object)it2, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void closesAllIteratorsOnShutdown() throws Exception {
        ResourceIterator it1 = (ResourceIterator)Mockito.spy((Object)IteratorUtil.asResourceIterator((Iterator)IteratorUtil.iterator((Object[])new Long[]{1L, 2L, 3L})));
        ResourceIterator it2 = (ResourceIterator)Mockito.spy((Object)IteratorUtil.asResourceIterator((Iterator)IteratorUtil.iterator((Object[])new Long[]{5L, 6L, 7L})));
        CombiningResourceIterator combingIterator = new CombiningResourceIterator(IteratorUtil.iterator((Object[])new ResourceIterator[]{it1, it2}));
        int iterations = 4;
        while (iterations-- > 0) {
            combingIterator.next();
        }
        combingIterator.close();
        ((ResourceIterator)Mockito.verify((Object)it1)).close();
        ((ResourceIterator)Mockito.verify((Object)it2)).close();
    }

    @Test
    public void shouldHandleSingleItemIterators() throws Exception {
        ResourceIterator it1 = IteratorUtil.asResourceIterator((Iterator)IteratorUtil.iterator((Object)1L));
        ResourceIterator it2 = IteratorUtil.asResourceIterator((Iterator)IteratorUtil.iterator((Object[])new Long[]{5L, 6L, 7L}));
        CombiningResourceIterator combingIterator = new CombiningResourceIterator(IteratorUtil.iterator((Object[])new ResourceIterator[]{it1, it2}));
        MatcherAssert.assertThat((Object)IteratorUtil.asList((Iterator)combingIterator), (Matcher)Matchers.equalTo(Arrays.asList(1L, 5L, 6L, 7L)));
    }
}

