/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.CachingIterator;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PagingIterator;
import org.neo4j.helpers.collection.RangeIterator;

public class TestCommonIterators {
    @Test
    public void testNoDuplicatesFilteringIterator() {
        List<Integer> ints = Arrays.asList(1, 2, 2, 40, 100, 40, 101, 2, 3);
        Iterator iterator = FilteringIterator.noDuplicates(ints.iterator());
        Assert.assertEquals((Object)1, iterator.next());
        Assert.assertEquals((Object)2, iterator.next());
        Assert.assertEquals((Object)40, iterator.next());
        Assert.assertEquals((Object)100, iterator.next());
        Assert.assertEquals((Object)101, iterator.next());
        Assert.assertEquals((Object)3, iterator.next());
    }

    @Test
    public void testCachingIterator() {
        RangeIterator source = new RangeIterator(8);
        CachingIterator caching = new CachingIterator((Iterator)source);
        try {
            caching.previous();
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            caching.current();
            Assert.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)caching.position());
        Assert.assertTrue((boolean)caching.hasNext());
        Assert.assertEquals((long)0L, (long)caching.position());
        Assert.assertFalse((boolean)caching.hasPrevious());
        Assert.assertEquals((Object)0, (Object)caching.next());
        Assert.assertTrue((boolean)caching.hasNext());
        Assert.assertTrue((boolean)caching.hasPrevious());
        Assert.assertEquals((Object)1, (Object)caching.next());
        Assert.assertTrue((boolean)caching.hasPrevious());
        Assert.assertEquals((Object)1, (Object)caching.current());
        Assert.assertEquals((Object)2, (Object)caching.next());
        Assert.assertEquals((Object)2, (Object)caching.current());
        Assert.assertEquals((Object)3, (Object)caching.position());
        Assert.assertEquals((Object)2, (Object)caching.current());
        Assert.assertTrue((boolean)caching.hasPrevious());
        Assert.assertEquals((Object)2, (Object)caching.previous());
        Assert.assertEquals((Object)2, (Object)caching.current());
        Assert.assertEquals((Object)2, (Object)caching.position());
        Assert.assertEquals((Object)1, (Object)caching.previous());
        Assert.assertEquals((Object)1, (Object)caching.current());
        Assert.assertEquals((Object)1, (Object)caching.position());
        Assert.assertEquals((Object)0, (Object)caching.previous());
        Assert.assertEquals((Object)0, (Object)caching.position());
        Assert.assertFalse((boolean)caching.hasPrevious());
        try {
            caching.position(-1);
            Assert.fail((String)"Shouldn't be able to set a lower value than 0");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)0, (Object)caching.current());
        Assert.assertEquals((long)0L, (long)caching.position(3));
        try {
            caching.current();
            Assert.fail((String)"Shouldn't be able to call current() after a call to position(int)");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)caching.hasNext());
        Assert.assertEquals((Object)3, (Object)caching.next());
        Assert.assertEquals((Object)3, (Object)caching.current());
        Assert.assertTrue((boolean)caching.hasPrevious());
        Assert.assertEquals((Object)4, (Object)caching.next());
        Assert.assertEquals((long)5L, (long)caching.position());
        Assert.assertEquals((Object)4, (Object)caching.previous());
        Assert.assertEquals((Object)4, (Object)caching.current());
        Assert.assertEquals((Object)4, (Object)caching.current());
        Assert.assertEquals((long)4L, (long)caching.position());
        Assert.assertEquals((Object)3, (Object)caching.previous());
        Assert.assertEquals((long)3L, (long)caching.position());
        try {
            caching.position(9);
            Assert.fail((String)"Shouldn't be able to set a position which is too big");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)caching.position(8));
        Assert.assertTrue((boolean)caching.hasPrevious());
        Assert.assertFalse((boolean)caching.hasNext());
        try {
            caching.next();
            Assert.fail((String)"Shouldn't be able to go beyond last item");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((long)8L, (long)caching.position());
        Assert.assertEquals((Object)7, (Object)caching.previous());
        Assert.assertEquals((Object)6, (Object)caching.previous());
        Assert.assertEquals((long)6L, (long)caching.position(0));
        Assert.assertEquals((Object)0, (Object)caching.next());
    }

    @Test
    public void testPagingIterator() {
        RangeIterator source = new RangeIterator(24);
        PagingIterator pager = new PagingIterator((Iterator)source, 10);
        Assert.assertEquals((long)0L, (long)pager.page());
        Assert.assertTrue((boolean)pager.hasNext());
        this.assertPage(pager.nextPage(), 10, 0);
        Assert.assertTrue((boolean)pager.hasNext());
        Assert.assertEquals((long)1L, (long)pager.page());
        Assert.assertTrue((boolean)pager.hasNext());
        this.assertPage(pager.nextPage(), 10, 10);
        Assert.assertTrue((boolean)pager.hasNext());
        Assert.assertEquals((long)2L, (long)pager.page());
        Assert.assertTrue((boolean)pager.hasNext());
        this.assertPage(pager.nextPage(), 4, 20);
        Assert.assertFalse((boolean)pager.hasNext());
        pager.page(1);
        Assert.assertEquals((long)1L, (long)pager.page());
        Assert.assertTrue((boolean)pager.hasNext());
        this.assertPage(pager.nextPage(), 10, 10);
        Assert.assertTrue((boolean)pager.hasNext());
    }

    private void assertPage(Iterator<Integer> page, int size, int plus) {
        for (int i = 0; i < size; ++i) {
            Assert.assertTrue((boolean)page.hasNext());
            Assert.assertEquals((Object)(i + plus), (Object)page.next());
        }
        Assert.assertFalse((boolean)page.hasNext());
    }

    @Test
    public void testFirstElement() {
        Object object = new Object();
        Object object2 = new Object();
        Assert.assertEquals((Object)object, (Object)IteratorUtil.first(Arrays.asList(object, object2)));
        Assert.assertEquals((Object)object, (Object)IteratorUtil.first(Arrays.asList(object)));
        try {
            IteratorUtil.first(Arrays.asList(new Object[0]));
            Assert.fail((String)"Should fail");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)object, (Object)IteratorUtil.first(Arrays.asList(object, object2).iterator()));
        Assert.assertEquals((Object)object, (Object)IteratorUtil.first(Arrays.asList(object).iterator()));
        try {
            IteratorUtil.first(Arrays.asList(new Object[0]).iterator());
            Assert.fail((String)"Should fail");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((Object)object, (Object)IteratorUtil.firstOrNull(Arrays.asList(object, object2)));
        Assert.assertEquals((Object)object, (Object)IteratorUtil.firstOrNull(Arrays.asList(object)));
        Assert.assertNull((Object)IteratorUtil.firstOrNull(Arrays.asList(new Object[0])));
        Assert.assertEquals((Object)object, (Object)IteratorUtil.firstOrNull(Arrays.asList(object, object2).iterator()));
        Assert.assertEquals((Object)object, (Object)IteratorUtil.firstOrNull(Arrays.asList(object).iterator()));
        Assert.assertNull((Object)IteratorUtil.firstOrNull(Arrays.asList(new Object[0]).iterator()));
    }

    @Test
    public void testLastElement() {
        Object object = new Object();
        Object object2 = new Object();
        Assert.assertEquals((Object)object2, (Object)IteratorUtil.last(Arrays.asList(object, object2)));
        Assert.assertEquals((Object)object, (Object)IteratorUtil.last(Arrays.asList(object)));
        try {
            IteratorUtil.last(Arrays.asList(new Object[0]));
            Assert.fail((String)"Should fail");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)object2, (Object)IteratorUtil.last(Arrays.asList(object, object2).iterator()));
        Assert.assertEquals((Object)object, (Object)IteratorUtil.last(Arrays.asList(object).iterator()));
        try {
            IteratorUtil.last(Arrays.asList(new Object[0]).iterator());
            Assert.fail((String)"Should fail");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((Object)object2, (Object)IteratorUtil.lastOrNull(Arrays.asList(object, object2)));
        Assert.assertEquals((Object)object, (Object)IteratorUtil.lastOrNull(Arrays.asList(object)));
        Assert.assertNull((Object)IteratorUtil.lastOrNull(Arrays.asList(new Object[0])));
        Assert.assertEquals((Object)object2, (Object)IteratorUtil.lastOrNull(Arrays.asList(object, object2).iterator()));
        Assert.assertEquals((Object)object, (Object)IteratorUtil.lastOrNull(Arrays.asList(object).iterator()));
        Assert.assertNull((Object)IteratorUtil.lastOrNull(Arrays.asList(new Object[0]).iterator()));
    }

    @Test
    public void testSingleElement() {
        Object object = new Object();
        Object object2 = new Object();
        Assert.assertEquals((Object)object, (Object)IteratorUtil.single(Arrays.asList(object)));
        try {
            IteratorUtil.single(Arrays.asList(new Object[0]));
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            IteratorUtil.single(Arrays.asList(object, object2));
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((Object)object, (Object)IteratorUtil.single(Arrays.asList(object).iterator()));
        try {
            IteratorUtil.single(Arrays.asList(new Object[0]).iterator());
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            IteratorUtil.single(Arrays.asList(object, object2).iterator());
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((Object)object, (Object)IteratorUtil.singleOrNull(Arrays.asList(object)));
        Assert.assertNull((Object)IteratorUtil.singleOrNull(Arrays.asList(new Object[0])));
        try {
            IteratorUtil.singleOrNull(Arrays.asList(object, object2));
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((Object)object, (Object)IteratorUtil.singleOrNull(Arrays.asList(object).iterator()));
        Assert.assertNull((Object)IteratorUtil.singleOrNull(Arrays.asList(new Object[0]).iterator()));
        try {
            IteratorUtil.singleOrNull(Arrays.asList(object, object2).iterator());
            Assert.fail((String)"Should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void getItemFromEnd() {
        List<Integer> ints = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        Assert.assertEquals((Object)9, (Object)IteratorUtil.fromEnd(ints, (int)0));
        Assert.assertEquals((Object)8, (Object)IteratorUtil.fromEnd(ints, (int)1));
        Assert.assertEquals((Object)7, (Object)IteratorUtil.fromEnd(ints, (int)2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fileAsIterator() throws Exception {
        String[] lines = new String[]{"first line", "second line and we're still good", "", "last line"};
        File file = this.createTextFileWithLines(lines);
        try {
            ClosableIterable iterable = IteratorUtil.asIterable((File)file, (String)"UTF-8");
            Assert.assertEquals(Arrays.asList(lines), (Object)IteratorUtil.asCollection((Iterable)iterable));
        }
        finally {
            file.delete();
        }
    }

    private File createTextFileWithLines(String[] lines) throws IOException {
        File file = File.createTempFile("lines", "neo4j");
        PrintStream out = new PrintStream(file);
        for (String line : lines) {
            out.println(line);
        }
        out.close();
        return file;
    }
}

