/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.kernel.logging.LogMarker;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.ImpermanentGraphDatabase;

public class DiagnosticsLoggingTest {
    @Test
    public void shouldSeeHelloWorld() {
        FakeDatabase db = new FakeDatabase(new HashMap<String, String>());
        FakeLogger logger = db.getLogger();
        String messages = logger.getMessages();
        Assert.assertThat((Object)messages, (Matcher)Matchers.containsString((String)"Network information"));
        Assert.assertThat((Object)messages, (Matcher)Matchers.containsString((String)"Disk space on partition"));
        Assert.assertThat((Object)messages, (Matcher)Matchers.containsString((String)"Local timezone"));
        db.shutdown();
    }

    @Test
    public void shouldSeePageCacheConfigurationWithDumpConfigurationEnabled() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(GraphDatabaseSettings.dump_configuration.name(), "true");
        settings.put(GraphDatabaseSettings.mapped_memory_total_size.name(), "8M");
        FakeDatabase db = new FakeDatabase(settings);
        FakeLogger logger = db.getLogger();
        String messages = logger.getMessages();
        Assert.assertThat((Object)messages, (Matcher)Matchers.containsString((String)"Page cache size: 8MB"));
        db.shutdown();
    }

    private class FakeDatabase
    extends ImpermanentGraphDatabase {
        public FakeDatabase(HashMap<String, String> settings) {
            super(settings);
        }

        @Override
        protected Logging createLogging() {
            return new FakeLogger();
        }

        public FakeLogger getLogger() {
            return (FakeLogger)this.logging;
        }
    }

    private class FakeLogger
    extends StringLogger
    implements Logging {
        private final StringBuilder messages = new StringBuilder();

        private FakeLogger() {
        }

        public String getMessages() {
            return this.messages.toString();
        }

        private void appendLine(String mess) {
            this.messages.append(mess).append("\n");
        }

        public void logLongMessage(String msg, Visitor<StringLogger.LineLogger, RuntimeException> source, boolean flush) {
            this.appendLine(msg);
            source.visit((Object)new StringLogger.LineLogger(){

                public void logLine(String line) {
                    FakeLogger.this.appendLine(line);
                }
            });
        }

        public void logMessage(String msg, boolean flush) {
            this.appendLine(msg);
        }

        public void logMessage(String msg, LogMarker marker) {
            this.appendLine(msg);
        }

        public void logMessage(String msg, Throwable cause, boolean flush) {
            this.appendLine(msg);
        }

        public void addRotationListener(Runnable listener) {
        }

        public void flush() {
        }

        public void close() {
        }

        protected void logLine(String line) {
            this.appendLine(line);
        }

        public StringLogger getMessagesLog(Class loggingClass) {
            return this;
        }

        public ConsoleLogger getConsoleLog(Class loggingClass) {
            return new ConsoleLogger(StringLogger.SYSTEM);
        }

        public void init() throws Throwable {
        }

        public void start() throws Throwable {
        }

        public void stop() throws Throwable {
        }

        public void shutdown() throws Throwable {
        }
    }
}

