/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.test.TargetDirectory;

public class StoreLockerLifecycleAdapterTest {
    @Rule
    public TestName testName = new TestName();
    private String storeDir;

    @Before
    public void before() {
        this.storeDir = TargetDirectory.forTest(this.getClass()).cleanDirectory(this.testName.getMethodName()).getAbsolutePath();
    }

    @Test
    public void shouldAllowDatabasesToUseFilesetsSequentially() throws Exception {
        new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir).shutdown();
        new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir).shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotAllowDatabasesToUseFilesetsConcurrently() throws Exception {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir);
        try {
            new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)IsInstanceOf.instanceOf(StoreLockException.class));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotAllowDatabasesToUseFilesetsConcurrentlyEvenIfTheyAreInReadOnlyMode() throws Exception {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir);
        try {
            new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.read_only, "true").newGraphDatabase();
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)IsInstanceOf.instanceOf(StoreLockException.class));
        }
        finally {
            db.shutdown();
        }
    }
}

