/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;

public class TestPlaceboTransaction {
    private TopLevelTransaction mockTopLevelTx;
    private Transaction placeboTx;
    private Node resource;

    @Before
    public void before() throws Exception {
        ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        Mockito.when((Object)bridge.instance()).thenReturn(Mockito.mock(Statement.class));
        this.mockTopLevelTx = (TopLevelTransaction)Mockito.mock(TopLevelTransaction.class);
        final TopLevelTransaction.TransactionOutcome outcome = new TopLevelTransaction.TransactionOutcome();
        Mockito.when((Object)this.mockTopLevelTx.getTransactionOutcome()).thenReturn((Object)outcome);
        ((TopLevelTransaction)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                outcome.failed();
                return null;
            }
        }).when((Object)this.mockTopLevelTx)).failure();
        this.placeboTx = new PlaceboTransaction(this.mockTopLevelTx);
        this.resource = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.resource.getId()).thenReturn((Object)1L);
    }

    @Test
    public void shouldRollbackParentByDefault() {
        this.placeboTx.close();
        ((TopLevelTransaction)Mockito.verify((Object)this.mockTopLevelTx)).failure();
    }

    @Test
    public void shouldRollbackParentIfFailureCalled() throws TransactionFailureException {
        this.placeboTx.failure();
        this.placeboTx.close();
        ((TopLevelTransaction)Mockito.verify((Object)this.mockTopLevelTx)).failure();
    }

    @Test
    public void shouldNotRollbackParentIfSuccessCalled() {
        this.placeboTx.success();
        this.placeboTx.close();
        ((TopLevelTransaction)Mockito.verify((Object)this.mockTopLevelTx, (VerificationMode)Mockito.times((int)0))).failure();
    }

    @Test
    public void successCannotOverrideFailure() throws Exception {
        this.placeboTx.failure();
        this.placeboTx.success();
        this.placeboTx.close();
        ((TopLevelTransaction)Mockito.verify((Object)this.mockTopLevelTx)).failure();
        ((TopLevelTransaction)Mockito.verify((Object)this.mockTopLevelTx, (VerificationMode)Mockito.times((int)0))).success();
    }

    @Test
    public void canAcquireReadLock() throws Exception {
        this.placeboTx.acquireReadLock((PropertyContainer)this.resource);
        ((TopLevelTransaction)Mockito.verify((Object)this.mockTopLevelTx)).acquireReadLock((PropertyContainer)this.resource);
    }

    @Test
    public void canAcquireWriteLock() throws Exception {
        this.placeboTx.acquireWriteLock((PropertyContainer)this.resource);
        ((TopLevelTransaction)Mockito.verify((Object)this.mockTopLevelTx)).acquireWriteLock((PropertyContainer)this.resource);
    }
}

