/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class UniqueIndexAccessorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    private static final int PROPERTY_KEY_ID = 100;
    private IndexAccessor accessor;

    public UniqueIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite);
    }

    @Ignore(value="Invalid assumption since we currently must rely on close throwing exception for injectedtransactions that violate a constraint")
    @Test
    public void closingAnOnlineIndexUpdaterMustNotThrowEvenIfItHasBeenFedConflictingData() throws Exception {
        this.updateAndCommit(Arrays.asList(NodePropertyUpdate.add((long)1L, (int)100, (Object)"a", (long[])new long[]{1000L}), NodePropertyUpdate.add((long)2L, (int)100, (Object)"a", (long[])new long[]{1000L})));
        Assert.assertThat(this.getAllNodes("a"), (Matcher)Matchers.equalTo(Arrays.asList(1L, 2L)));
    }

    @Before
    public void before() throws IOException {
        IndexConfiguration indexConfig = new IndexConfiguration(true);
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(new Config());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexConfig, indexSamplingConfig);
        populator.create();
        populator.close(true);
        this.accessor = this.indexProvider.getOnlineAccessor(17L, indexConfig, indexSamplingConfig);
    }

    @After
    public void after() throws IOException {
        this.accessor.drop();
        this.accessor.close();
    }

    private List<Long> getAllNodes(String propertyValue) throws IOException {
        try (IndexReader reader = this.accessor.newReader();){
            LinkedList<Long> list = new LinkedList<Long>();
            PrimitiveLongIterator iterator = reader.lookup((Object)propertyValue);
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            Collections.sort(list);
            LinkedList<Long> linkedList = list;
            return linkedList;
        }
    }

    private void updateAndCommit(List<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (NodePropertyUpdate update : updates) {
                updater.process(update);
            }
        }
    }
}

