/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.counts.keys.RelationshipKey;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class CompositeCountsTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    private Provider<Statement> statementProvider;

    @Test
    public void shouldReportNumberOfRelationshipsFromNodesWithGivenLabel() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            Node foo = this.db.createNode(DynamicLabel.label((String)"Foo"));
            Node fooBar = this.db.createNode(DynamicLabel.label((String)"Foo"), DynamicLabel.label((String)"Bar"));
            Node bar = this.db.createNode(DynamicLabel.label((String)"Bar"));
            foo.createRelationshipTo(this.db.createNode(new Label[0]), (RelationshipType)DynamicRelationshipType.withName((String)"ALPHA"));
            foo.createRelationshipTo(fooBar, (RelationshipType)DynamicRelationshipType.withName((String)"BETA"));
            fooBar.createRelationshipTo(this.db.createNode(DynamicLabel.label((String)"Bar")), (RelationshipType)DynamicRelationshipType.withName((String)"BETA"));
            fooBar.createRelationshipTo(this.db.createNode(new Label[0]), (RelationshipType)DynamicRelationshipType.withName((String)"GAMMA"));
            bar.createRelationshipTo(this.db.createNode(DynamicLabel.label((String)"Foo")), (RelationshipType)DynamicRelationshipType.withName((String)"GAMMA"));
            tx.success();
        }
        this.verifyAllCounts();
    }

    @Test
    public void shouldMaintainCountsOnRelationshipCreate() throws Exception {
        Node bar;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(DynamicLabel.label((String)"Foo"));
            bar = this.db.createNode(DynamicLabel.label((String)"Bar"));
            tx.success();
        }
        this.verifyAllCounts();
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.createRelationshipTo(bar, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Foo"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Bar"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.verifyAllCounts();
    }

    @Test
    public void shouldMaintainCountsOnRelationshipDelete() throws Exception {
        Relationship relationship;
        try (Transaction tx = this.db.beginTx();){
            relationship = this.db.createNode(DynamicLabel.label((String)"Foo")).createRelationshipTo(this.db.createNode(DynamicLabel.label((String)"Bar")), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            relationship.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Foo"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Bar")).shouldBe(0L);
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Bar"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.verifyAllCounts();
    }

    @Test
    public void shouldMaintainCountsOnLabelAdd() throws Exception {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[0]);
            Node bar = this.db.createNode(DynamicLabel.label((String)"Bar"));
            foo.createRelationshipTo(bar, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        this.verifyAllCounts();
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.addLabel(DynamicLabel.label((String)"Foo"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Foo"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Bar"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.verifyAllCounts();
    }

    @Test
    public void shouldMaintainCountsOnLabelRemove() throws Exception {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(DynamicLabel.label((String)"Foo"));
            Node bar = this.db.createNode(DynamicLabel.label((String)"Bar"));
            foo.createRelationshipTo(bar, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.removeLabel(DynamicLabel.label((String)"Foo"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Foo"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Bar"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.verifyAllCounts();
    }

    @Test
    public void shouldMaintainCountsOnLabelAddAndRelationshipCreate() throws Exception {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(DynamicLabel.label((String)"Foo"));
            Node bar = this.db.createNode(DynamicLabel.label((String)"Bar"));
            foo.createRelationshipTo(bar, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.addLabel(DynamicLabel.label((String)"Bar"));
            foo.createRelationshipTo(this.db.createNode(DynamicLabel.label((String)"Foo")), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Foo"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Bar"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(2L);
        this.verifyAllCounts();
    }

    @Test
    public void shouldMaintainCountsOnLabelRemoveAndRelationshipDelete() throws Exception {
        Relationship rel;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(DynamicLabel.label((String)"Foo"), DynamicLabel.label((String)"Bar"));
            Node bar = this.db.createNode(DynamicLabel.label((String)"Bar"));
            foo.createRelationshipTo(bar, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            rel = bar.createRelationshipTo(foo, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var5_2 = null;
        try {
            foo.removeLabel(DynamicLabel.label((String)"Bar"));
            rel.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var5_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Foo"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Bar"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.verifyAllCounts();
    }

    @Test
    public void shouldMaintainCountsOnLabelAddAndRelationshipDelete() throws Exception {
        Relationship rel;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(DynamicLabel.label((String)"Foo"));
            Node bar = this.db.createNode(DynamicLabel.label((String)"Bar"));
            foo.createRelationshipTo(bar, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            rel = bar.createRelationshipTo(foo, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var5_2 = null;
        try {
            foo.addLabel(DynamicLabel.label((String)"Bar"));
            rel.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var5_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Foo"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Bar"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.verifyAllCounts();
    }

    @Test
    public void shouldMaintainCountsOnLabelRemoveAndRelationshipCreate() throws Exception {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(DynamicLabel.label((String)"Foo"), DynamicLabel.label((String)"Bar"));
            Node bar = this.db.createNode(DynamicLabel.label((String)"Bar"));
            foo.createRelationshipTo(bar, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.removeLabel(DynamicLabel.label((String)"Bar"));
            foo.createRelationshipTo(this.db.createNode(DynamicLabel.label((String)"Foo")), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Foo"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), DynamicLabel.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(DynamicLabel.label((String)"Bar"), (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.verifyAllCounts();
    }

    @Test
    public void shouldNotUpdateCountsIfCreatedRelationshipIsDeletedInSameTransaction() throws Exception {
        Node bar;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(DynamicLabel.label((String)"Foo"));
            bar = this.db.createNode(DynamicLabel.label((String)"Bar"));
            tx.success();
        }
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            foo.createRelationshipTo(bar, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS")).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.verifyAllCounts();
    }

    private void verifyAllCounts() {
        NeoStore stores = (NeoStore)this.db.resolveDependency(NeoStoreProvider.class).evaluate();
        List differences = CountsComputer.computeCounts((NeoStore)stores).verify((CountsVisitor.Visitable)stores.getCounts());
        if (!differences.isEmpty()) {
            StringBuilder error = new StringBuilder();
            for (CountsRecordState.Difference difference : differences) {
                RelationshipKey key;
                if (difference.key() instanceof RelationshipKey && (key = (RelationshipKey)difference.key()).startLabelId() != -1 && key.endLabelId() != -1) continue;
                error.append("\n\t").append(difference);
            }
            if (error.length() > 0) {
                Assert.fail((String)error.toString());
            }
        }
    }

    private MatchingRelationships numberOfRelationshipsMatching(Label lhs, RelationshipType type, Label rhs) {
        try (Transaction tx = this.db.getGraphDatabaseService().beginTx();){
            long nodeCount = this.countsForRelationship(lhs, type, rhs);
            tx.success();
            MatchingRelationships matchingRelationships = new MatchingRelationships(String.format("(%s)-%s->(%s)", lhs == null ? "" : ":" + lhs.name(), type == null ? "" : "[:" + type.name() + "]", rhs == null ? "" : ":" + rhs.name()), nodeCount);
            return matchingRelationships;
        }
    }

    private long countsForRelationship(Label start, RelationshipType type, Label end) {
        int endId;
        int typeId;
        int startId;
        ReadOperations read = ((Statement)this.statementProvider.instance()).readOperations();
        if (start == null) {
            startId = -1;
        } else {
            startId = read.labelGetForName(start.name());
            if (-1 == startId) {
                return 0L;
            }
        }
        if (type == null) {
            typeId = -1;
        } else {
            typeId = read.relationshipTypeGetForName(type.name());
            if (-1 == typeId) {
                return 0L;
            }
        }
        if (end == null) {
            endId = -1;
        } else {
            endId = read.labelGetForName(end.name());
            if (-1 == endId) {
                return 0L;
            }
        }
        return read.countsForRelationship(startId, typeId, endId);
    }

    @Before
    public void exposeGuts() {
        this.statementProvider = (Provider)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    private static class MatchingRelationships {
        private final String message;
        private final long count;

        public MatchingRelationships(String message, long count) {
            this.message = message;
            this.count = count;
        }

        public void shouldBe(long expected) {
            Assert.assertEquals((String)this.message, (long)expected, (long)this.count);
        }
    }
}

