/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class LabelCountsTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    private Provider<Statement> statementProvider;

    @Test
    public void shouldGetNumberOfNodesWithLabel() throws Exception {
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            graphDb.createNode(new Label[]{DynamicLabel.label((String)"Foo")});
            graphDb.createNode(new Label[]{DynamicLabel.label((String)"Bar")});
            graphDb.createNode(new Label[]{DynamicLabel.label((String)"Bar")});
            tx.success();
        }
        long fooCount = this.numberOfNodesWith(DynamicLabel.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(DynamicLabel.label((String)"Bar"));
        Assert.assertEquals((long)1L, (long)fooCount);
        Assert.assertEquals((long)2L, (long)barCount);
    }

    @Test
    public void shouldAccountForDeletedNodes() throws Exception {
        Node node;
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            node = graphDb.createNode(new Label[]{DynamicLabel.label((String)"Foo")});
            graphDb.createNode(new Label[]{DynamicLabel.label((String)"Foo")});
            tx.success();
        }
        tx = graphDb.beginTx();
        var4_4 = null;
        try {
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long fooCount = this.numberOfNodesWith(DynamicLabel.label((String)"Foo"));
        Assert.assertEquals((long)1L, (long)fooCount);
    }

    @Test
    public void shouldAccountForAddedLabels() throws Exception {
        Node n3;
        Node n2;
        Node n1;
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            n1 = graphDb.createNode(new Label[]{DynamicLabel.label((String)"Foo")});
            n2 = graphDb.createNode();
            n3 = graphDb.createNode();
            tx.success();
        }
        tx = graphDb.beginTx();
        var6_4 = null;
        try {
            n1.addLabel(DynamicLabel.label((String)"Bar"));
            n2.addLabel(DynamicLabel.label((String)"Bar"));
            n3.addLabel(DynamicLabel.label((String)"Foo"));
            tx.success();
        }
        catch (Throwable x2) {
            var6_4 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var6_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var6_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long fooCount = this.numberOfNodesWith(DynamicLabel.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(DynamicLabel.label((String)"Bar"));
        Assert.assertEquals((long)2L, (long)fooCount);
        Assert.assertEquals((long)2L, (long)barCount);
    }

    @Test
    public void shouldAccountForRemovedLabels() throws Exception {
        Node n3;
        Node n2;
        Node n1;
        GraphDatabaseService graphDb = this.db.getGraphDatabaseService();
        try (Transaction tx = graphDb.beginTx();){
            n1 = graphDb.createNode(new Label[]{DynamicLabel.label((String)"Foo"), DynamicLabel.label((String)"Bar")});
            n2 = graphDb.createNode(new Label[]{DynamicLabel.label((String)"Bar")});
            n3 = graphDb.createNode(new Label[]{DynamicLabel.label((String)"Foo")});
            tx.success();
        }
        tx = graphDb.beginTx();
        var6_4 = null;
        try {
            n1.removeLabel(DynamicLabel.label((String)"Bar"));
            n2.removeLabel(DynamicLabel.label((String)"Bar"));
            n3.removeLabel(DynamicLabel.label((String)"Foo"));
            tx.success();
        }
        catch (Throwable x2) {
            var6_4 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var6_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var6_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long fooCount = this.numberOfNodesWith(DynamicLabel.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(DynamicLabel.label((String)"Bar"));
        Assert.assertEquals((long)1L, (long)fooCount);
        Assert.assertEquals((long)0L, (long)barCount);
    }

    private long numberOfNodesWith(Label label) {
        try (Transaction tx = this.db.getGraphDatabaseService().beginTx();){
            long nodeCount = this.countsForNode(label);
            tx.success();
            long l = nodeCount;
            return l;
        }
    }

    private long countsForNode(Label label) {
        int labelId;
        ReadOperations read = ((Statement)this.statementProvider.instance()).readOperations();
        if (label == null) {
            labelId = -1;
        } else {
            labelId = read.labelGetForName(label.name());
            if (-1 == labelId) {
                return 0L;
            }
        }
        return read.countsForNode(labelId);
    }

    @Before
    public void exposeGuts() {
        this.statementProvider = (Provider)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }
}

