/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsStoreApplier;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;

public class CountsStoreApplierTest {
    private final CountsAccessor countsAccessor = (CountsAccessor)Mockito.mock(CountsAccessor.class);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);

    @Test
    public void shouldNotifyCacheAccessOnHowManyUpdatesOnCountsWeHadSoFar() throws IOException {
        CountsStoreApplier applier = new CountsStoreApplier(this.countsAccessor, this.nodeStore);
        applier.visitNodeCommand(this.addNodeCommand());
        applier.apply();
        ((CountsAccessor)Mockito.verify((Object)this.countsAccessor, (VerificationMode)Mockito.times((int)1))).incrementNodeCount(-1, 1L);
    }

    private Command.NodeCommand addNodeCommand() {
        Command.NodeCommand command = new Command.NodeCommand();
        command.init(new NodeRecord(1L, false, 2L, 3L, false), new NodeRecord(1L, false, 2L, 3L, true));
        return command;
    }
}

