/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.kernel.impl.util.TestLogging;

public class KernelSchemaStateStoreTest {
    private KernelSchemaStateStore stateStore;
    private TestLogging logging = new TestLogging();

    @Test
    public void should_apply_updates_correctly() {
        this.stateStore.apply(MapUtil.stringMap((String[])new String[]{"key", "created_value"}));
        String result = (String)this.stateStore.get((Object)"key");
        Assert.assertEquals((Object)"created_value", (Object)result);
    }

    @Test
    public void should_flush() {
        this.stateStore.apply(MapUtil.stringMap((String[])new String[]{"key", "created_value"}));
        this.stateStore.clear();
        String result = (String)this.stateStore.get((Object)"key");
        Assert.assertEquals(null, (Object)result);
        this.logger().assertExactly(TestLogger.LogCall.info("Schema state store has been cleared."));
    }

    @Before
    public void before() {
        this.stateStore = new KernelSchemaStateStore((StringLogger)this.logging.getMessagesLog(KernelSchemaStateStore.class));
    }

    private TestLogger logger() {
        return this.logging.getMessagesLog(KernelSchemaStateStore.class);
    }
}

