/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.api.RecordStateForCacheAccessor;
import org.neo4j.kernel.impl.core.FirstRelationshipIds;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.ControlledLoaders;
import org.neo4j.kernel.impl.util.RelIdArray;

public class RecordStateForCacheAccessorTest {
    @Test
    public void shouldProvideFirstRelationshipIdOfSparseNode() throws Exception {
        ControlledLoaders fakeStore = new ControlledLoaders();
        long nodeId = 0L;
        long relId = 3L;
        fakeStore.getNodes().put(nodeId, new NodeRecord(nodeId, false, relId, -1L, true));
        fakeStore.getRelationships().put(relId, new RelationshipRecord(relId, true, 0L, 0L, 0, -1L, -1L, -1L, -1L, true, true));
        RecordStateForCacheAccessor accessor = new RecordStateForCacheAccessor(fakeStore.newAccessSet());
        FirstRelationshipIds firstIds = accessor.firstRelationshipIdsOf(nodeId);
        Assert.assertEquals((long)relId, (long)firstIds.firstIdOf(0, RelIdArray.DirectionWrapper.OUTGOING));
        Assert.assertEquals((long)relId, (long)firstIds.firstIdOf(2, RelIdArray.DirectionWrapper.BOTH));
    }

    @Test
    public void shouldProvideFirstRelationshipIdsOfDenseNode() throws Exception {
        ControlledLoaders fakeStore = new ControlledLoaders();
        long nodeId = 2L;
        int firstType = 1;
        int secondType = 2;
        long firstGroupId = 5L;
        long firstGroupOut = 10L;
        long firstGroupIn = -1L;
        long firstGroupLoop = 7L;
        long secondGroupId = 7L;
        long secondGroupOut = -1L;
        long secondGroupIn = 20L;
        long secondGroupLoop = 22L;
        fakeStore.getNodes().put(nodeId, new NodeRecord(nodeId, true, firstGroupId, -1L, true));
        fakeStore.getRelationshipGroups().put(firstGroupId, new RelationshipGroupRecord(firstGroupId, firstType, firstGroupOut, firstGroupIn, firstGroupLoop, nodeId, secondGroupId, true));
        fakeStore.getRelationshipGroups().put(secondGroupId, new RelationshipGroupRecord(secondGroupId, secondType, secondGroupOut, secondGroupIn, secondGroupLoop, nodeId, true));
        RecordStateForCacheAccessor accessor = new RecordStateForCacheAccessor(fakeStore.newAccessSet());
        FirstRelationshipIds firstIds = accessor.firstRelationshipIdsOf(nodeId);
        Assert.assertEquals((long)firstGroupOut, (long)firstIds.firstIdOf(firstType, RelIdArray.DirectionWrapper.OUTGOING));
        Assert.assertEquals((long)firstGroupIn, (long)firstIds.firstIdOf(firstType, RelIdArray.DirectionWrapper.INCOMING));
        Assert.assertEquals((long)firstGroupLoop, (long)firstIds.firstIdOf(firstType, RelIdArray.DirectionWrapper.BOTH));
        Assert.assertEquals((long)secondGroupOut, (long)firstIds.firstIdOf(secondType, RelIdArray.DirectionWrapper.OUTGOING));
        Assert.assertEquals((long)secondGroupIn, (long)firstIds.firstIdOf(secondType, RelIdArray.DirectionWrapper.INCOMING));
        Assert.assertEquals((long)secondGroupLoop, (long)firstIds.firstIdOf(secondType, RelIdArray.DirectionWrapper.BOTH));
    }
}

