/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.LegacyIndexApplier;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

public class TransactionRepresentationStoreApplierTest {
    private final IndexingService indexService = (IndexingService)Mockito.mock(IndexingService.class);
    private final LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private final NeoStore neoStore = (NeoStore)Mockito.mock(NeoStore.class);
    private final CacheAccessBackDoor cacheAccess = (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class);
    private final LockService lockService = new ReentrantLockService();
    private final LegacyIndexApplier.ProviderLookup legacyIndexProviderLookup = (LegacyIndexApplier.ProviderLookup)Mockito.mock(LegacyIndexApplier.ProviderLookup.class);
    private final IndexConfigStore indexConfigStore = (IndexConfigStore)Mockito.mock(IndexConfigStore.class);
    private final IdOrderingQueue queue = (IdOrderingQueue)Mockito.mock(IdOrderingQueue.class);
    private final int transactionId = 12;

    public TransactionRepresentationStoreApplierTest() {
        CountsTracker tracker = (CountsTracker)Mockito.mock(CountsTracker.class);
        Mockito.when((Object)this.neoStore.getCounts()).thenReturn((Object)tracker);
        Mockito.when((Object)tracker.acceptTx(Matchers.anyLong())).thenReturn((Object)true);
    }

    @Test
    public void transactionRepresentationShouldAcceptApplierVisitor() throws IOException {
        TransactionRepresentationStoreApplier applier = new TransactionRepresentationStoreApplier(this.indexService, this.labelScanStore, this.neoStore, this.cacheAccess, this.lockService, this.legacyIndexProviderLookup, this.indexConfigStore, this.queue);
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        try (LockGroup locks = new LockGroup();){
            applier.apply(transaction, locks, 12L, TransactionApplicationMode.INTERNAL);
        }
        ((TransactionRepresentation)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).accept((Visitor)Matchers.any());
    }

    @Test
    public void shouldUpdateIdGeneratorsOnExternalCommit() throws IOException {
        NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
        Mockito.when((Object)this.neoStore.getNodeStore()).thenReturn((Object)nodeStore);
        TransactionRepresentationStoreApplier applier = new TransactionRepresentationStoreApplier(this.indexService, this.labelScanStore, this.neoStore, this.cacheAccess, this.lockService, this.legacyIndexProviderLookup, this.indexConfigStore, this.queue);
        long nodeId = 5L;
        TransactionRepresentation transaction = this.createNodeTransaction(nodeId);
        try (LockGroup locks = new LockGroup();){
            applier.apply(transaction, locks, 12L, TransactionApplicationMode.EXTERNAL);
        }
        ((NodeStore)Mockito.verify((Object)nodeStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(nodeId);
    }

    private TransactionRepresentation createNodeTransaction(long nodeId) {
        return new PhysicalTransactionRepresentation(Arrays.asList(this.createNodeCommand(nodeId)));
    }

    private Command createNodeCommand(long nodeId) {
        Command.NodeCommand command = new Command.NodeCommand();
        NodeRecord after = new NodeRecord(nodeId);
        after.setInUse(true);
        command.init(new NodeRecord(nodeId), after);
        return command;
    }

    @Test
    public void shouldNotifyIdQueueWhenAppliedToLegacyIndexes() throws Exception {
        IdOrderingQueue queue = (IdOrderingQueue)Mockito.mock(IdOrderingQueue.class);
        TransactionRepresentationStoreApplier applier = new TransactionRepresentationStoreApplier(this.indexService, this.labelScanStore, this.neoStore, this.cacheAccess, this.lockService, this.legacyIndexProviderLookup, this.indexConfigStore, queue);
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(this.indexTransaction());
        try (LockGroup locks = new LockGroup();){
            applier.apply((TransactionRepresentation)transaction, locks, 12L, TransactionApplicationMode.INTERNAL);
        }
        ((IdOrderingQueue)Mockito.verify((Object)queue)).removeChecked(12L);
    }

    private Collection<Command> indexTransaction() {
        IndexDefineCommand definitions = new IndexDefineCommand();
        definitions.init(MapUtil.genericMap((Object[])new Object[]{"one", (byte)1}), MapUtil.genericMap((Object[])new Object[]{"two", (byte)2}));
        return Arrays.asList(definitions);
    }
}

