/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.heuristics.StatisticsData;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.util.Providers;

public class ConstraintIndexCreatorTest {
    @Test
    public void shouldCreateIndexInAnotherTransaction() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        StatementOperationParts indexCreationContext = StatementOperationsTestHelper.mockedParts();
        IndexDescriptor descriptor = new IndexDescriptor(123, 456);
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, descriptor, SchemaStorage.IndexRuleKind.CONSTRAINT)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(2468L)).thenReturn((Object)indexProxy);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(Providers.singletonProvider((Object)kernel), indexingService);
        long indexId = creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), 123, 456);
        Assert.assertEquals((long)2468L, (long)indexId);
        Assert.assertEquals((long)1L, (long)kernel.statements.size());
        ((TransactionState)Mockito.verify((Object)((KernelStatement)kernel.statements.get(0)).txState())).constraintIndexRuleDoAdd(descriptor);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{indexCreationContext.schemaWriteOperations()});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetCommittedId(state, descriptor, SchemaStorage.IndexRuleKind.CONSTRAINT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted();
    }

    @Test
    public void shouldDropIndexIfPopulationFails() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexDescriptor descriptor = new IndexDescriptor(123, 456);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, descriptor, SchemaStorage.IndexRuleKind.CONSTRAINT)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(2468L)).thenReturn((Object)indexProxy);
        PreexistingIndexEntryConflictException cause = new PreexistingIndexEntryConflictException((Object)"a", 2L, 1L);
        ((IndexProxy)Mockito.doThrow((Throwable)new IndexPopulationFailedKernelException(descriptor, "some index", (Throwable)cause)).when((Object)indexProxy)).awaitStoreScanCompleted();
        ConstraintIndexCreator creator = new ConstraintIndexCreator(Providers.singletonProvider((Object)kernel), indexingService);
        try {
            creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), 123, 456);
            Assert.fail((String)"expected exception");
        }
        catch (ConstraintVerificationFailedKernelException e) {
            Assert.assertEquals((Object)"Existing data does not satisfy CONSTRAINT ON ( n:label[123] ) ASSERT n.property[456] IS UNIQUE.", (Object)e.getMessage());
        }
        Assert.assertEquals((long)2L, (long)kernel.statements.size());
        TransactionState tx1 = ((KernelStatement)kernel.statements.get(0)).txState();
        ((TransactionState)Mockito.verify((Object)tx1)).constraintIndexRuleDoAdd(new IndexDescriptor(123, 456));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx1});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetCommittedId(state, descriptor, SchemaStorage.IndexRuleKind.CONSTRAINT);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
        TransactionState tx2 = ((KernelStatement)kernel.statements.get(1)).txState();
        ((TransactionState)Mockito.verify((Object)tx2)).constraintIndexDoDrop(new IndexDescriptor(123, 456));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx2});
    }

    @Test
    public void shouldDropIndexInAnotherTransaction() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexDescriptor descriptor = new IndexDescriptor(123, 456);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(Providers.singletonProvider((Object)kernel), indexingService);
        creator.dropUniquenessConstraintIndex(descriptor);
        Assert.assertEquals((long)1L, (long)kernel.statements.size());
        ((TransactionState)Mockito.verify((Object)((KernelStatement)kernel.statements.get(0)).txState())).constraintIndexDoDrop(descriptor);
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexingService});
    }

    public class StubKernel
    implements KernelAPI {
        private final List<KernelStatement> statements = new ArrayList<KernelStatement>();

        public KernelTransaction newTransaction() {
            return new KernelTransaction(){

                public void success() {
                }

                public void failure() {
                }

                public void close() throws TransactionFailureException {
                }

                public Statement acquireStatement() {
                    return this.remember(StatementOperationsTestHelper.mockedState());
                }

                private Statement remember(KernelStatement mockedState) {
                    StubKernel.this.statements.add(mockedState);
                    return mockedState;
                }

                public boolean isOpen() {
                    return true;
                }

                public boolean shouldBeTerminated() {
                    return false;
                }

                public void markForTermination() {
                }
            };
        }

        public void registerTransactionHook(TransactionHook hook) {
            throw new UnsupportedOperationException("Please implement");
        }

        public void unregisterTransactionHook(TransactionHook hook) {
            throw new UnsupportedOperationException("Please implement");
        }

        public StatisticsData heuristics() {
            throw new UnsupportedOperationException("Please implement");
        }
    }
}

