/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.CollectingIndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.register.Register;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class IndexRecoveryIT {
    private GraphDatabaseAPI db;
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final SchemaIndexProvider mockedIndexProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
    private final KernelExtensionFactory<?> mockedIndexProviderFactory = SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory(TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR.getKey(), this.mockedIndexProvider);
    private final String key = "number_of_bananas_owned";
    private final Label myLabel = DynamicLabel.label((String)"MyLabel");

    @Test
    public void shouldBeAbleToRecoverInTheMiddleOfPopulatingAnIndex() throws Exception {
        this.startDb();
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)this.indexPopulatorWithControlledCompletionTiming(latch));
        this.createIndex(this.myLabel);
        Future<Void> killFuture = this.killDbInSeparateThread();
        latch.countDown();
        killFuture.get();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState(Matchers.anyLong())).thenReturn((Object)InternalIndexState.POPULATING);
        latch = new CountDownLatch(1);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)this.indexPopulatorWithControlledCompletionTiming(latch));
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.hasSize(1)));
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.POPULATING)));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)2))).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)0))).getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        latch.countDown();
    }

    @Test
    public void shouldBeAbleToRecoverInTheMiddleOfPopulatingAnIndexWhereLogHasRotated() throws Exception {
        this.startDb();
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)this.indexPopulatorWithControlledCompletionTiming(latch));
        this.createIndex(this.myLabel);
        this.rotateLogs();
        Future<Void> killFuture = this.killDbInSeparateThread();
        latch.countDown();
        killFuture.get();
        latch = new CountDownLatch(1);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)this.indexPopulatorWithControlledCompletionTiming(latch));
        Mockito.when((Object)this.mockedIndexProvider.getInitialState(Matchers.anyLong())).thenReturn((Object)InternalIndexState.POPULATING);
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.hasSize(1)));
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.POPULATING)));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)2))).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)0))).getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        latch.countDown();
    }

    @Test
    public void shouldBeAbleToRecoverAndUpdateOnlineIndex() throws Exception {
        this.startDb();
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)populator);
        Mockito.when((Object)populator.sampleResult((Register.DoubleLong.Out)Matchers.any(Register.DoubleLong.Out.class))).thenAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) throws Throwable {
                Register.DoubleLong.Out result = (Register.DoubleLong.Out)invocation.getArguments()[0];
                result.write(0L, 0L);
                return 0L;
            }
        });
        IndexAccessor mockedAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        Mockito.when((Object)mockedAccessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)SwallowingIndexUpdater.INSTANCE);
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)mockedAccessor);
        this.createIndexAndAwaitPopulation(this.myLabel);
        this.rotateLogs();
        Set<NodePropertyUpdate> expectedUpdates = this.createSomeBananas(this.myLabel);
        this.killDb();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState(Matchers.anyLong())).thenReturn((Object)InternalIndexState.ONLINE);
        GatheringIndexWriter writer = new GatheringIndexWriter();
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)writer);
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.hasSize(1)));
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.ONLINE)));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)1))).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        int onlineAccessorInvocationCount = 2;
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)onlineAccessorInvocationCount))).getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
        Assert.assertEquals(expectedUpdates, (Object)writer.recoveredUpdates);
        for (NodePropertyUpdate update : writer.recoveredUpdates) {
            Assert.assertTrue((boolean)writer.recoveredNodes.contains(update.getNodeId()));
        }
    }

    @Test
    public void shouldKeepFailedIndexesAsFailedAfterRestart() throws Exception {
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn(Mockito.mock(IndexPopulator.class));
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn(Mockito.mock(IndexAccessor.class));
        this.startDb();
        this.createIndex(this.myLabel);
        this.rotateLogs();
        this.killDb();
        Mockito.when((Object)this.mockedIndexProvider.getInitialState(Matchers.anyLong())).thenReturn((Object)InternalIndexState.FAILED);
        this.startDb();
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.hasSize(1)));
        Assert.assertThat(Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, this.myLabel), Neo4jMatchers.inTx((GraphDatabaseService)this.db, Neo4jMatchers.haveState((GraphDatabaseService)this.db, Schema.IndexState.FAILED)));
        ((SchemaIndexProvider)Mockito.verify((Object)this.mockedIndexProvider, (VerificationMode)Mockito.times((int)2))).getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class));
    }

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockedIndexProvider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.mockedIndexProvider.compareTo((SchemaIndexProvider)Matchers.any(SchemaIndexProvider.class))).thenReturn((Object)1);
        Mockito.when((Object)this.mockedIndexProvider.storeMigrationParticipant()).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
    }

    private void startDb() {
        if (this.db != null) {
            this.db.shutdown();
        }
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setFileSystem((FileSystemAbstraction)this.fs.get());
        factory.addKernelExtensions(Arrays.asList(this.mockedIndexProviderFactory));
        this.db = (GraphDatabaseAPI)factory.newImpermanentDatabase();
    }

    private void killDb() {
        if (this.db != null) {
            this.fs.snapshot(new Runnable(){

                @Override
                public void run() {
                    IndexRecoveryIT.this.db.shutdown();
                    IndexRecoveryIT.this.db = null;
                }
            });
        }
    }

    private Future<Void> killDbInSeparateThread() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> result = executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IndexRecoveryIT.this.killDb();
                return null;
            }
        });
        executor.shutdown();
        return result;
    }

    @After
    public void after() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    private void rotateLogs() throws IOException {
        ((LogRotation)this.db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
    }

    private void createIndexAndAwaitPopulation(Label label) {
        IndexDefinition index = this.createIndex(label);
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(index, 10L, TimeUnit.SECONDS);
            tx.success();
        }
    }

    private IndexDefinition createIndex(Label label) {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition index = this.db.schema().indexFor(label).on("number_of_bananas_owned").create();
            tx.success();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    private Set<NodePropertyUpdate> createSomeBananas(Label label) {
        HashSet<NodePropertyUpdate> updates = new HashSet<NodePropertyUpdate>();
        try (Transaction tx = this.db.beginTx();){
            ThreadToStatementContextBridge ctxProvider = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            try (Statement statement = ctxProvider.instance();){
                for (int number : new int[]{4, 10}) {
                    Node node = this.db.createNode(new Label[]{label});
                    node.setProperty("number_of_bananas_owned", (Object)number);
                    updates.add(NodePropertyUpdate.add((long)node.getId(), (int)statement.readOperations().propertyKeyGetForName("number_of_bananas_owned"), (Object)number, (long[])new long[]{statement.readOperations().labelGetForName(label.name())}));
                }
            }
            tx.success();
            HashSet<NodePropertyUpdate> hashSet = updates;
            return hashSet;
        }
    }

    private IndexPopulator indexPopulatorWithControlledCompletionTiming(final CountDownLatch latch) {
        return new IndexPopulator.Adapter(){

            public void create() {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                throw new RuntimeException("this is expected");
            }
        };
    }

    public static class GatheringIndexWriter
    extends IndexAccessor.Adapter {
        private final Set<NodePropertyUpdate> regularUpdates = new HashSet<NodePropertyUpdate>();
        private final Set<NodePropertyUpdate> recoveredUpdates = new HashSet<NodePropertyUpdate>();
        private final Set<Long> recoveredNodes = new HashSet<Long>();

        public IndexUpdater newUpdater(final IndexUpdateMode mode) {
            return new CollectingIndexUpdater(){

                public void close() throws IOException, IndexEntryConflictException {
                    switch (mode) {
                        case ONLINE: {
                            GatheringIndexWriter.this.regularUpdates.addAll(this.updates);
                            break;
                        }
                        case RECOVERY: {
                            GatheringIndexWriter.this.recoveredUpdates.addAll(this.updates);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                }

                public void remove(Collection<Long> nodeIds) throws IOException {
                    for (Long nodeId : nodeIds) {
                        GatheringIndexWriter.this.recoveredNodes.add(nodeId);
                    }
                }
            };
        }
    }
}

