/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.register.Register;
import org.neo4j.test.Barrier;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class IndexSamplingIntegrationTest {
    private final Barrier.Control samplingStarted = new Barrier.Control();
    private final Barrier.Control samplingDone = new Barrier.Control();
    private volatile Throwable samplingException;
    private final InMemoryIndexProvider index = new InMemoryIndexProvider(100){

        @Override
        public IndexAccessor getOnlineAccessor(long indexId, IndexConfiguration indexConfig, IndexSamplingConfig samplingConfig) {
            return new IndexAccessor.Delegator(super.getOnlineAccessor(indexId, indexConfig, samplingConfig)){

                public IndexReader newReader() {
                    return new IndexReader.Delegator(super.newReader()){

                        public long sampleIndex(Register.DoubleLong.Out result) throws IndexNotFoundKernelException {
                            IndexSamplingIntegrationTest.this.samplingStarted.reached();
                            try {
                                long l = super.sampleIndex(result);
                                return l;
                            }
                            catch (Throwable e) {
                                IndexSamplingIntegrationTest.this.samplingException = e;
                                throw e;
                            }
                            finally {
                                IndexSamplingIntegrationTest.this.samplingDone.reached();
                            }
                        }
                    };
                }
            };
        }
    };
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseFactory factory) {
            factory.addKernelExtension((KernelExtensionFactory)new InMemoryIndexProviderFactory(IndexSamplingIntegrationTest.this.index));
        }

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.index_background_sampling_enabled, "false");
        }
    };

    @Test
    public void shouldStopSamplingWhenIndexIsDropped() throws Exception {
        IndexDefinition index = this.awaitOnline(this.indexOn(DynamicLabel.label((String)"Foo"), "bar"));
        this.db.resolveDependency(IndexingService.class).triggerIndexSampling(IndexSamplingMode.TRIGGER_REBUILD_ALL);
        this.samplingStarted.await();
        this.drop(index);
        this.samplingDone.release();
        this.samplingStarted.release();
        this.samplingDone.await();
        Throwable exception = this.samplingException;
        Assert.assertThat((Object)exception, (Matcher)Matchers.instanceOf(IndexNotFoundKernelException.class));
        Assert.assertEquals((Object)"Index dropped while sampling.", (Object)exception.getMessage());
    }

    private void drop(IndexDefinition index) {
        try (Transaction tx = this.db.beginTx();){
            index.drop();
            tx.success();
        }
    }

    private IndexDefinition indexOn(Label label, String propertyKey) {
        IndexDefinition index;
        try (Transaction tx = this.db.beginTx();){
            index = this.db.schema().indexFor(label).on(propertyKey).create();
            tx.success();
        }
        return index;
    }

    private IndexDefinition awaitOnline(IndexDefinition index) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexOnline(index, 3L, TimeUnit.SECONDS);
            tx.success();
        }
        return index;
    }
}

