/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.impl.util.TestLogger;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.AwaitAnswer;

public class IndexingServiceTest {
    @Rule
    public final LifeRule life = new LifeRule();
    private final int labelId = 7;
    private final int propertyKeyId = 15;
    private final IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
    private final IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
    private final SchemaIndexProvider indexProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class, (Answer)Mockito.RETURNS_MOCKS);
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    private final TokenNameLookup nameLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
    private final TestLogging logging = new TestLogging();

    @Test
    public void shouldBringIndexOnlineAndFlipOverToIndexAccessor() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        indexingService.createIndex(IndexRule.indexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((int)1000))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.ONLINE);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    public void indexCreationShouldBeIdempotent() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        indexingService.createIndex(IndexRule.indexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        indexingService.createIndex(IndexRule.indexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
    }

    @Test
    public void shouldDeliverUpdatesThatOccurDuringPopulationToPopulator() throws Exception {
        Mockito.when((Object)this.populator.newPopulatingUpdater((PropertyAccessor)this.storeView)).thenReturn((Object)this.updater);
        CountDownLatch latch = new CountDownLatch(1);
        ((IndexPopulator)Mockito.doAnswer(AwaitAnswer.afterAwaiting(latch)).when((Object)this.populator)).add(Matchers.anyLong(), Matchers.any());
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(this.add(1L, "value1")), new IndexRule[0]);
        this.life.start();
        indexingService.createIndex(IndexRule.indexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR));
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        NodePropertyUpdate value2 = this.add(2L, "value2");
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(value2);
        }
        latch.countDown();
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((int)1000))).close(true);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).add(1L, (Object)"value1");
        ((IndexPopulator)order.verify((Object)this.populator)).newPopulatingUpdater((PropertyAccessor)this.storeView);
        ((IndexUpdater)order.verify((Object)this.updater)).close();
        ((IndexPopulator)order.verify((Object)this.populator)).verifyDeferredConstraints((PropertyAccessor)this.storeView);
        ((IndexPopulator)order.verify((Object)this.populator)).sampleResult((Register.DoubleLong.Out)Matchers.any(Register.DoubleLong.Out.class));
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.updater});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.populator});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.accessor});
    }

    @Test
    public void shouldStillReportInternalIndexStateAsPopulatingWhenConstraintIndexIsDonePopulating() throws Exception {
        Mockito.when((Object)this.accessor.newUpdater((IndexUpdateMode)Matchers.any(IndexUpdateMode.class))).thenReturn((Object)this.updater);
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        indexingService.createIndex(IndexRule.constraintIndexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, null));
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        ((IndexPopulator)Mockito.verify((Object)this.populator, (VerificationMode)Mockito.timeout((int)1000))).close(true);
        try (IndexUpdater updater = proxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(this.add(10L, "foo"));
        }
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor, this.updater});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
        ((IndexAccessor)order.verify((Object)this.accessor)).newUpdater(IndexUpdateMode.ONLINE);
        ((IndexUpdater)order.verify((Object)this.updater)).process(this.add(10L, "foo"));
        ((IndexUpdater)order.verify((Object)this.updater)).close();
    }

    @Test
    public void shouldBringConstraintIndexOnlineWhenExplicitlyToldTo() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        this.life.start();
        indexingService.createIndex(IndexRule.constraintIndexRule((long)0L, (int)7, (int)15, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, null));
        IndexProxy proxy = indexingService.getIndexProxy(0L);
        indexingService.activateIndex(0L);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)proxy.getState());
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.populator, this.accessor});
        ((IndexPopulator)order.verify((Object)this.populator)).create();
        ((IndexPopulator)order.verify((Object)this.populator)).close(true);
    }

    @Test
    public void shouldLogIndexStateOnInit() throws Exception {
        TestLogger logger = new TestLogger();
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(provider);
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexRule onlineIndex = IndexRule.indexRule((long)1L, (int)1, (int)1, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule populatingIndex = IndexRule.indexRule((long)2L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule failedIndex = IndexRule.indexRule((long)3L, (int)2, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexingService = (IndexingService)this.life.add(IndexingService.create((IndexSamplingConfig)new IndexSamplingConfig(new Config()), (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (SchemaIndexProviderMap)providerMap, (IndexStoreView)((IndexStoreView)Mockito.mock(IndexStoreView.class)), (TokenNameLookup)mockLookup, (UpdateableSchemaState)((UpdateableSchemaState)Mockito.mock(UpdateableSchemaState.class)), Arrays.asList(onlineIndex, populatingIndex, failedIndex), (Logging)IndexingServiceTest.mockLogging(logger), (IndexingService.Monitor)IndexingService.NO_MONITOR));
        Mockito.when((Object)provider.getInitialState(onlineIndex.getId())).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex.getId())).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex.getId())).thenReturn((Object)InternalIndexState.FAILED);
        Mockito.when((Object)mockLookup.labelGetName(1)).thenReturn((Object)"LabelOne");
        Mockito.when((Object)mockLookup.labelGetName(2)).thenReturn((Object)"LabelTwo");
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"propertyOne");
        Mockito.when((Object)mockLookup.propertyKeyGetName(2)).thenReturn((Object)"propertyTwo");
        this.life.init();
        logger.assertExactly(TestLogger.LogCall.info("IndexingService.init: index 1 on :LabelOne(propertyOne) is ONLINE"), TestLogger.LogCall.info("IndexingService.init: index 2 on :LabelOne(propertyTwo) is POPULATING"), TestLogger.LogCall.info("IndexingService.init: index 3 on :LabelTwo(propertyTwo) is FAILED"));
    }

    @Test
    public void shouldLogIndexStateOnStart() throws Exception {
        TestLogger logger = new TestLogger();
        SchemaIndexProvider provider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(provider);
        TokenNameLookup mockLookup = (TokenNameLookup)Mockito.mock(TokenNameLookup.class);
        IndexRule onlineIndex = IndexRule.indexRule((long)1L, (int)1, (int)1, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule populatingIndex = IndexRule.indexRule((long)2L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule failedIndex = IndexRule.indexRule((long)3L, (int)2, (int)2, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexingService = IndexingService.create((IndexSamplingConfig)new IndexSamplingConfig(new Config()), (JobScheduler)((JobScheduler)Mockito.mock(JobScheduler.class)), (SchemaIndexProviderMap)providerMap, (IndexStoreView)this.storeView, (TokenNameLookup)mockLookup, (UpdateableSchemaState)((UpdateableSchemaState)Mockito.mock(UpdateableSchemaState.class)), Arrays.asList(onlineIndex, populatingIndex, failedIndex), (Logging)IndexingServiceTest.mockLogging(logger), (IndexingService.Monitor)IndexingService.NO_MONITOR);
        Mockito.when((Object)provider.getInitialState(onlineIndex.getId())).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)provider.getInitialState(populatingIndex.getId())).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)provider.getInitialState(failedIndex.getId())).thenReturn((Object)InternalIndexState.FAILED);
        indexingService.init();
        Mockito.when((Object)mockLookup.labelGetName(1)).thenReturn((Object)"LabelOne");
        Mockito.when((Object)mockLookup.labelGetName(2)).thenReturn((Object)"LabelTwo");
        Mockito.when((Object)mockLookup.propertyKeyGetName(1)).thenReturn((Object)"propertyOne");
        Mockito.when((Object)mockLookup.propertyKeyGetName(2)).thenReturn((Object)"propertyTwo");
        Mockito.when((Object)this.storeView.indexSample((IndexDescriptor)Matchers.any(IndexDescriptor.class), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        logger.clear();
        indexingService.start();
        ((SchemaIndexProvider)Mockito.verify((Object)provider)).getPopulationFailure(3L);
        logger.assertAtLeastOnce(TestLogger.LogCall.info("IndexingService.start: index 1 on :LabelOne(propertyOne) is ONLINE"));
        logger.assertAtLeastOnce(TestLogger.LogCall.info("IndexingService.start: index 2 on :LabelOne(propertyTwo) is POPULATING"));
        logger.assertAtLeastOnce(TestLogger.LogCall.info("IndexingService.start: index 3 on :LabelTwo(propertyTwo) is FAILED"));
    }

    @Test
    public void shouldFailToStartIfMissingIndexProvider() throws Exception {
        String otherProviderKey = "something-completely-different";
        SchemaIndexProvider.Descriptor otherDescriptor = new SchemaIndexProvider.Descriptor(otherProviderKey, "no-version");
        IndexRule rule = IndexRule.indexRule((long)1L, (int)2, (int)3, (SchemaIndexProvider.Descriptor)otherDescriptor);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), (IndexAccessor)Mockito.mock(IndexAccessor.class), new DataUpdates(new NodePropertyUpdate[0]), rule);
        try {
            this.life.init();
            Assert.fail((String)"initIndexes with mismatching index provider should fail");
        }
        catch (LifecycleException e) {
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"existing index"));
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)otherProviderKey));
        }
    }

    @Test
    public void shouldSnapshotOnlineIndexes() throws Exception {
        int indexId = 1;
        int indexId2 = 2;
        IndexRule rule1 = IndexRule.indexRule((long)indexId, (int)2, (int)3, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule rule2 = IndexRule.indexRule((long)indexId2, (int)4, (int)5, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies((IndexPopulator)Mockito.mock(IndexPopulator.class), indexAccessor, new DataUpdates(new NodePropertyUpdate[0]), rule1, rule2);
        File theFile = new File("Blah");
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(this.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId2)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.storeView.indexSample((IndexDescriptor)Matchers.any(IndexDescriptor.class), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotStoreFiles();
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterator)files), (Matcher)org.hamcrest.Matchers.equalTo((Object)IteratorUtil.asCollection((Iterator)IteratorUtil.iterator((Object[])new File[]{theFile, theFile}))));
    }

    @Test
    public void shouldNotSnapshotPopulatingIndexes() throws Exception {
        CountDownLatch populatorLatch = new CountDownLatch(1);
        IndexAccessor indexAccessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
        int indexId = 1;
        int indexId2 = 2;
        IndexRule rule1 = IndexRule.indexRule((long)indexId, (int)2, (int)3, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexRule rule2 = IndexRule.indexRule((long)indexId2, (int)4, (int)5, (SchemaIndexProvider.Descriptor)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        IndexingService indexing = this.newIndexingServiceWithMockedDependencies(this.populator, indexAccessor, new DataUpdates(new NodePropertyUpdate[0]), rule1, rule2);
        File theFile = new File("Blah");
        ((IndexPopulator)Mockito.doAnswer((Answer)this.waitForLatch(populatorLatch)).when((Object)this.populator)).create();
        Mockito.when((Object)indexAccessor.snapshotFiles()).thenAnswer(this.newResourceIterator(theFile));
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId)).thenReturn((Object)InternalIndexState.POPULATING);
        Mockito.when((Object)this.indexProvider.getInitialState((long)indexId2)).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.storeView.indexSample((IndexDescriptor)Matchers.any(IndexDescriptor.class), (Register.DoubleLongRegister)Matchers.any(Register.DoubleLongRegister.class))).thenReturn((Object)Registers.newDoubleLongRegister((long)32L, (long)32L));
        this.life.start();
        ResourceIterator files = indexing.snapshotStoreFiles();
        populatorLatch.countDown();
        Assert.assertThat((Object)IteratorUtil.asCollection((Iterator)files), (Matcher)org.hamcrest.Matchers.equalTo((Object)IteratorUtil.asCollection((Iterator)IteratorUtil.iterator((Object)theFile))));
    }

    @Test
    public void shouldIgnoreActivateCallDuringRecovery() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        indexingService.activateIndex(0L);
    }

    @Test
    public void shouldLogTriggerSamplingOnAllIndexes() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        IndexSamplingMode mode = IndexSamplingMode.TRIGGER_REBUILD_ALL;
        indexingService.triggerIndexSampling(mode);
        this.logging.getMessagesLog(IndexingService.class).assertAtLeastOnce(TestLogger.LogCall.info("Manual trigger for sampling all indexes [" + mode + "]"));
    }

    @Test
    public void shouldLogTriggerSamplingOnAnIndexes() throws Exception {
        IndexingService indexingService = this.newIndexingServiceWithMockedDependencies(this.populator, this.accessor, this.withData(new NodePropertyUpdate[0]), new IndexRule[0]);
        IndexSamplingMode mode = IndexSamplingMode.TRIGGER_REBUILD_ALL;
        IndexDescriptor descriptor = new IndexDescriptor(0, 1);
        indexingService.triggerIndexSampling(descriptor, mode);
        String userDescription = descriptor.userDescription(this.nameLookup);
        this.logging.getMessagesLog(IndexingService.class).assertAtLeastOnce(TestLogger.LogCall.info("Manual trigger for sampling index " + userDescription + " [" + mode + "]"));
    }

    private Answer waitForLatch(final CountDownLatch latch) {
        return new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                latch.await();
                return null;
            }
        };
    }

    private Answer<ResourceIterator<File>> newResourceIterator(final File theFile) {
        return new Answer<ResourceIterator<File>>(){

            public ResourceIterator<File> answer(InvocationOnMock invocationOnMock) throws Throwable {
                return IteratorUtil.asResourceIterator((Iterator)IteratorUtil.iterator((Object)theFile));
            }
        };
    }

    private static Logging mockLogging(StringLogger logger) {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Mockito.when((Object)logging.getMessagesLog((Class)Matchers.any(Class.class))).thenReturn((Object)logger);
        return logging;
    }

    private NodePropertyUpdate add(long nodeId, Object propertyValue) {
        return NodePropertyUpdate.add((long)nodeId, (int)15, (Object)propertyValue, (long[])new long[]{7L});
    }

    private IndexingService newIndexingServiceWithMockedDependencies(IndexPopulator populator, IndexAccessor accessor, DataUpdates data, IndexRule ... rules) throws IOException {
        UpdateableSchemaState schemaState = (UpdateableSchemaState)Mockito.mock(UpdateableSchemaState.class);
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.indexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)populator);
        data.getsProcessedByStoreScanFrom(this.storeView);
        Mockito.when((Object)this.indexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)accessor);
        Mockito.when((Object)this.indexProvider.snapshotMetaFiles()).thenReturn((Object)IteratorUtil.emptyIterator());
        Mockito.when((Object)this.indexProvider.storeMigrationParticipant()).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        Mockito.when((Object)this.nameLookup.labelGetName(Matchers.anyInt())).thenAnswer((Answer)new NameLookupAnswer("label"));
        Mockito.when((Object)this.nameLookup.propertyKeyGetName(Matchers.anyInt())).thenAnswer((Answer)new NameLookupAnswer("property"));
        return (IndexingService)this.life.add(IndexingService.create((IndexSamplingConfig)new IndexSamplingConfig(new Config()), (JobScheduler)((JobScheduler)this.life.add(new Neo4jJobScheduler())), (SchemaIndexProviderMap)new DefaultSchemaIndexProviderMap(this.indexProvider), (IndexStoreView)this.storeView, (TokenNameLookup)this.nameLookup, (UpdateableSchemaState)schemaState, (Iterable)IteratorUtil.loop((Iterator)IteratorUtil.iterator((Object[])rules)), (Logging)this.logging, (IndexingService.Monitor)IndexingService.NO_MONITOR));
    }

    private DataUpdates withData(NodePropertyUpdate ... updates) {
        return new DataUpdates(updates);
    }

    private static class NameLookupAnswer
    implements Answer<String> {
        private final String kind;

        public NameLookupAnswer(String kind) {
            this.kind = kind;
        }

        public String answer(InvocationOnMock invocation) throws Throwable {
            int id = (Integer)invocation.getArguments()[0];
            return this.kind + "[" + id + "]";
        }
    }

    private static class DataUpdates
    implements Answer<StoreScan<RuntimeException>>,
    Iterable<NodePropertyUpdate> {
        private final NodePropertyUpdate[] updates;

        DataUpdates(NodePropertyUpdate[] updates) {
            this.updates = updates;
        }

        void getsProcessedByStoreScanFrom(IndexStoreView mock) {
            Mockito.when((Object)mock.visitNodesWithPropertyAndLabel((IndexDescriptor)Matchers.any(IndexDescriptor.class), DataUpdates.visitor(Matchers.any(Visitor.class)))).thenAnswer((Answer)this);
        }

        public StoreScan<RuntimeException> answer(InvocationOnMock invocation) throws Throwable {
            final Visitor<NodePropertyUpdate, RuntimeException> visitor = DataUpdates.visitor(invocation.getArguments()[1]);
            return new StoreScan<RuntimeException>(){

                public void run() {
                    for (NodePropertyUpdate update : DataUpdates.this.updates) {
                        visitor.visit((Object)update);
                    }
                }

                public void stop() {
                }
            };
        }

        private static Visitor<NodePropertyUpdate, RuntimeException> visitor(Object v) {
            return (Visitor)v;
        }

        @Override
        public Iterator<NodePropertyUpdate> iterator() {
            return new ArrayIterator((Object[])this.updates);
        }

        public String toString() {
            return Arrays.toString(this.updates);
        }
    }
}

