/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.index.ArrayEncoder;
import org.neo4j.kernel.api.index.IndexReader;

abstract class InMemoryIndexImplementation
implements IndexReader,
BoundedIterable<Long> {
    InMemoryIndexImplementation() {
    }

    abstract void initialize();

    abstract void drop();

    public final PrimitiveLongIterator lookup(Object value) {
        return this.doLookup(InMemoryIndexImplementation.encode(value));
    }

    final boolean add(long nodeId, Object propertyValue, boolean applyIdempotently) {
        return this.doAdd(InMemoryIndexImplementation.encode(propertyValue), nodeId, applyIdempotently);
    }

    final void remove(long nodeId, Object propertyValue) {
        this.doRemove(InMemoryIndexImplementation.encode(propertyValue), nodeId);
    }

    abstract PrimitiveLongIterator doLookup(Object var1);

    abstract boolean doAdd(Object var1, long var2, boolean var4);

    abstract void doRemove(Object var1, long var2);

    abstract void remove(long var1);

    abstract void iterateAll(IndexEntryIterator var1) throws Exception;

    public void close() {
    }

    private static Object encode(Object propertyValue) {
        if (propertyValue instanceof Number) {
            return ((Number)propertyValue).doubleValue();
        }
        if (propertyValue instanceof Character) {
            return propertyValue.toString();
        }
        if (propertyValue.getClass().isArray()) {
            return new ArrayKey(ArrayEncoder.encode((Object)propertyValue));
        }
        return propertyValue;
    }

    abstract InMemoryIndexImplementation snapshot();

    protected static interface IndexEntryIterator {
        public void visitEntry(Object var1, Set<Long> var2) throws Exception;
    }

    private static class ArrayKey {
        private final String arrayValue;

        private ArrayKey(String arrayValue) {
            this.arrayValue = arrayValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayKey other = (ArrayKey)o;
            return other.arrayValue.equals(this.arrayValue);
        }

        public int hashCode() {
            return this.arrayValue != null ? this.arrayValue.hashCode() : 0;
        }
    }
}

