/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.UniquePropertyIndexUpdater;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndex;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexImplementation;

class UniqueInMemoryIndex
extends InMemoryIndex {
    private final int propertyKeyId;

    public UniqueInMemoryIndex(int propertyKeyId) {
        this.propertyKeyId = propertyKeyId;
    }

    @Override
    protected IndexUpdater newUpdater(final IndexUpdateMode mode, boolean populating) {
        return new UniquePropertyIndexUpdater(){

            protected void flushUpdates(Iterable<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException {
                for (NodePropertyUpdate update : updates) {
                    switch (update.getUpdateMode()) {
                        case CHANGED: 
                        case REMOVED: {
                            UniqueInMemoryIndex.this.remove(update.getNodeId(), update.getValueBefore());
                        }
                    }
                }
                for (NodePropertyUpdate update : updates) {
                    switch (update.getUpdateMode()) {
                        case CHANGED: 
                        case ADDED: {
                            UniqueInMemoryIndex.this.add(update.getNodeId(), update.getValueAfter(), IndexUpdateMode.ONLINE == mode);
                        }
                    }
                }
            }

            public void remove(Collection<Long> nodeIds) {
                for (long nodeId : nodeIds) {
                    UniqueInMemoryIndex.this.remove(nodeId);
                }
            }
        };
    }

    @Override
    public void verifyDeferredConstraints(final PropertyAccessor accessor) throws Exception {
        this.indexData.iterateAll(new InMemoryIndexImplementation.IndexEntryIterator(){

            @Override
            public void visitEntry(Object key, Set<Long> nodeIds) throws Exception {
                ArrayList<Entry> entries = new ArrayList<Entry>();
                for (long nodeId : nodeIds) {
                    Property property = accessor.getProperty(nodeId, UniqueInMemoryIndex.this.propertyKeyId);
                    Object value = property.value();
                    for (Entry current : entries) {
                        if (!current.property.valueEquals(value)) continue;
                        throw new PreexistingIndexEntryConflictException(value, current.nodeId, nodeId);
                    }
                    entries.add(new Entry(nodeId, property));
                }
            }
        });
    }

    private static class Entry {
        long nodeId;
        Property property;

        private Entry(long nodeId, Property property) {
            this.nodeId = nodeId;
            this.property = property;
        }
    }
}

