/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.test.DoubleLatch;

public class IndexSamplingJobTrackerTest {
    private final IndexSamplingConfig config = (IndexSamplingConfig)Mockito.mock(IndexSamplingConfig.class);

    @Test
    public void shouldNotRunASampleJobWhichIsAlreadyRunning() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)2);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        final DoubleLatch latch = new DoubleLatch();
        final AtomicInteger count = new AtomicInteger(0);
        Assert.assertTrue((boolean)jobTracker.canExecuteMoreSamplingJobs());
        IndexSamplingJob job = new IndexSamplingJob(){
            private final IndexDescriptor descriptor = new IndexDescriptor(1, 2);

            public void run() {
                count.incrementAndGet();
                latch.awaitStart();
                latch.finish();
            }

            public IndexDescriptor descriptor() {
                return this.descriptor;
            }
        };
        jobTracker.scheduleSamplingJob(job);
        jobTracker.scheduleSamplingJob(job);
        latch.start();
        latch.awaitFinish();
        Assert.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void shouldNotAcceptMoreJobsThanAllowed() throws Throwable {
        Mockito.when((Object)this.config.jobLimit()).thenReturn((Object)1);
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        final IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, (JobScheduler)jobScheduler);
        final DoubleLatch latch = new DoubleLatch();
        final DoubleLatch waitingLatch = new DoubleLatch();
        Assert.assertTrue((boolean)jobTracker.canExecuteMoreSamplingJobs());
        jobTracker.scheduleSamplingJob(new IndexSamplingJob(){
            private final IndexDescriptor descriptor = new IndexDescriptor(1, 2);

            public void run() {
                latch.start();
                latch.awaitFinish();
            }

            public IndexDescriptor descriptor() {
                return this.descriptor;
            }
        });
        latch.awaitStart();
        Assert.assertFalse((boolean)jobTracker.canExecuteMoreSamplingJobs());
        final AtomicBoolean waiting = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                waiting.set(true);
                waitingLatch.start();
                jobTracker.waitUntilCanExecuteMoreSamplingJobs();
                waiting.set(false);
                waitingLatch.finish();
            }
        }).start();
        waitingLatch.awaitStart();
        Assert.assertTrue((boolean)waiting.get());
        latch.finish();
        waitingLatch.awaitFinish();
        Assert.assertFalse((boolean)waiting.get());
        while (!jobTracker.canExecuteMoreSamplingJobs()) {
            Thread.yield();
        }
    }
}

