/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.kernel.impl.util.ExpandTestUtils;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.kernel.impl.util.register.NeoRegisters;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class ExpandIT
extends KernelIntegrationTest {
    private int relType1;
    private int relType2;

    @Test
    public void shouldTraverseBothDirections() throws Exception {
        long nodeId = this.createGraph();
        ReadOperations ops = this.readOperationsInNewTransaction();
        NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
        NeoRegister.NodeRegister startId = NeoRegisters.newNodeRegister();
        NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
        Register.ObjectRegister direction = Registers.newObjectRegister();
        NeoRegister.NodeRegister neighborId = NeoRegisters.newNodeRegister();
        Cursor cursor = ops.expand(Cursors.countDownCursor((int)1), (NeoRegister.Node.In)NeoRegisters.newNodeRegister((long)nodeId), (Register.Object.In)Registers.newObjectRegister((Object)new int[]{this.relType1}), (Register.Object.In)Registers.newObjectRegister((Object)Direction.BOTH), (NeoRegister.Relationship.Out)relId, (NeoRegister.RelType.Out)relType, (Register.Object.Out)direction, (NeoRegister.Node.Out)startId, (NeoRegister.Node.Out)neighborId);
        Assert.assertThat(ExpandTestUtils.rows(cursor, relId, relType, (Register.ObjectRegister<Direction>)direction, startId, neighborId), (Matcher)Matchers.equalTo(Arrays.asList(ExpandTestUtils.row(0L, 0, Direction.BOTH, 0L, 0L), ExpandTestUtils.row(1L, 0, Direction.BOTH, 0L, 0L), ExpandTestUtils.row(2L, 0, Direction.OUTGOING, 0L, 1L), ExpandTestUtils.row(3L, 0, Direction.OUTGOING, 0L, 1L), ExpandTestUtils.row(4L, 0, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(5L, 0, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(6L, 0, Direction.OUTGOING, 0L, 2L), ExpandTestUtils.row(7L, 0, Direction.OUTGOING, 0L, 2L), ExpandTestUtils.row(8L, 0, Direction.INCOMING, 0L, 2L), ExpandTestUtils.row(9L, 0, Direction.INCOMING, 0L, 2L))));
        Assert.assertFalse((String)"Should not contain any more rows.", (boolean)cursor.next());
    }

    @Test
    public void shouldTraverseIncoming() throws Exception {
        long nodeId = this.createGraph();
        ReadOperations ops = this.readOperationsInNewTransaction();
        NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
        NeoRegister.NodeRegister startId = NeoRegisters.newNodeRegister();
        NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
        Register.ObjectRegister direction = Registers.newObjectRegister();
        NeoRegister.NodeRegister neighborId = NeoRegisters.newNodeRegister();
        Cursor cursor = ops.expand(Cursors.countDownCursor((int)1), (NeoRegister.Node.In)NeoRegisters.newNodeRegister((long)nodeId), (Register.Object.In)Registers.newObjectRegister((Object)new int[]{this.relType1}), (Register.Object.In)Registers.newObjectRegister((Object)Direction.INCOMING), (NeoRegister.Relationship.Out)relId, (NeoRegister.RelType.Out)relType, (Register.Object.Out)direction, (NeoRegister.Node.Out)startId, (NeoRegister.Node.Out)neighborId);
        Assert.assertThat(ExpandTestUtils.rows(cursor, relId, relType, (Register.ObjectRegister<Direction>)direction, startId, neighborId), (Matcher)Matchers.equalTo(Arrays.asList(ExpandTestUtils.row(0L, 0, Direction.BOTH, 0L, 0L), ExpandTestUtils.row(1L, 0, Direction.BOTH, 0L, 0L), ExpandTestUtils.row(4L, 0, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(5L, 0, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(8L, 0, Direction.INCOMING, 0L, 2L), ExpandTestUtils.row(9L, 0, Direction.INCOMING, 0L, 2L))));
        Assert.assertFalse((String)"Should not contain any more rows.", (boolean)cursor.next());
    }

    @Test
    public void shouldTraverseOutgoingFromNodeCreatedInCurrentTx() throws Exception {
        this.createGraph();
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        long nodeId = ops.nodeCreate();
        ops.relationshipCreate(this.relType1, nodeId, ops.nodeCreate());
        ops.relationshipDelete(ops.relationshipCreate(this.relType1, nodeId, ops.nodeCreate()));
        NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
        NeoRegister.NodeRegister startId = NeoRegisters.newNodeRegister();
        NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
        Register.ObjectRegister direction = Registers.newObjectRegister();
        NeoRegister.NodeRegister neighborId = NeoRegisters.newNodeRegister();
        Cursor cursor = ops.expand(Cursors.countDownCursor((int)1), (NeoRegister.Node.In)NeoRegisters.newNodeRegister((long)nodeId), (Register.Object.In)Registers.newObjectRegister((Object)new int[]{this.relType1}), (Register.Object.In)Registers.newObjectRegister((Object)Direction.OUTGOING), (NeoRegister.Relationship.Out)relId, (NeoRegister.RelType.Out)relType, (Register.Object.Out)direction, (NeoRegister.Node.Out)startId, (NeoRegister.Node.Out)neighborId);
        Assert.assertThat(ExpandTestUtils.rows(cursor, relId, relType, (Register.ObjectRegister<Direction>)direction, startId, neighborId), (Matcher)Matchers.equalTo(Arrays.asList(ExpandTestUtils.row(12L, this.relType1, Direction.OUTGOING, nodeId, 6L))));
        Assert.assertFalse((String)"Should not contain any more rows.", (boolean)cursor.next());
    }

    @Test
    public void shouldIncludeTxLocalChangesOnIncoming() throws Exception {
        long nodeId = this.createGraph();
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
        NeoRegister.NodeRegister startId = NeoRegisters.newNodeRegister();
        NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
        Register.ObjectRegister direction = Registers.newObjectRegister();
        NeoRegister.NodeRegister neighborId = NeoRegisters.newNodeRegister();
        ops.relationshipDelete(0L);
        ops.relationshipCreate(this.relType1, nodeId, ops.nodeCreate());
        ops.relationshipCreate(this.relType1, ops.nodeCreate(), nodeId);
        Cursor cursor = ops.expand(Cursors.countDownCursor((int)1), (NeoRegister.Node.In)NeoRegisters.newNodeRegister((long)nodeId), (Register.Object.In)Registers.newObjectRegister((Object)new int[]{this.relType1}), (Register.Object.In)Registers.newObjectRegister((Object)Direction.INCOMING), (NeoRegister.Relationship.Out)relId, (NeoRegister.RelType.Out)relType, (Register.Object.Out)direction, (NeoRegister.Node.Out)startId, (NeoRegister.Node.Out)neighborId);
        Assert.assertThat(ExpandTestUtils.rows(cursor, relId, relType, (Register.ObjectRegister<Direction>)direction, startId, neighborId), (Matcher)Matchers.equalTo(Arrays.asList(ExpandTestUtils.row(1L, this.relType1, Direction.BOTH, 0L, 0L), ExpandTestUtils.row(4L, this.relType1, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(5L, this.relType1, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(8L, this.relType1, Direction.INCOMING, 0L, 2L), ExpandTestUtils.row(9L, this.relType1, Direction.INCOMING, 0L, 2L), ExpandTestUtils.row(13L, this.relType1, Direction.INCOMING, nodeId, 6L))));
        Assert.assertFalse((String)"Should not contain any more rows.", (boolean)cursor.next());
    }

    @Test
    public void shouldAllowMultipleInputRowsWithLocalTxState() throws Exception {
        final long nodeId = this.createGraph();
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
        NeoRegister.NodeRegister startId = NeoRegisters.newNodeRegister();
        NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
        Register.ObjectRegister direction = Registers.newObjectRegister();
        NeoRegister.NodeRegister neighborId = NeoRegisters.newNodeRegister();
        ops.relationshipDelete(0L);
        ops.relationshipCreate(this.relType1, nodeId, ops.nodeCreate());
        ops.relationshipCreate(this.relType1, ops.nodeCreate(), nodeId);
        ops.relationshipCreate(this.relType2, nodeId, ops.nodeCreate());
        final NeoRegister.NodeRegister nodeRegister = NeoRegisters.newNodeRegister();
        final Register.ObjectRegister typesRegister = Registers.newObjectRegister();
        final Register.ObjectRegister directionRegister = Registers.newObjectRegister();
        Cursor inputCursor = new Cursor(){
            private int count = 0;

            public boolean next() {
                switch (this.count++) {
                    case 0: {
                        nodeRegister.write(nodeId);
                        typesRegister.write((Object)new int[]{ExpandIT.this.relType1});
                        directionRegister.write((Object)Direction.INCOMING);
                        return true;
                    }
                    case 1: {
                        nodeRegister.write(nodeId);
                        typesRegister.write((Object)new int[]{ExpandIT.this.relType2});
                        directionRegister.write((Object)Direction.OUTGOING);
                        return true;
                    }
                }
                return false;
            }

            public void reset() {
            }

            public void close() {
            }
        };
        Cursor cursor = ops.expand(inputCursor, (NeoRegister.Node.In)nodeRegister, (Register.Object.In)typesRegister, (Register.Object.In)directionRegister, (NeoRegister.Relationship.Out)relId, (NeoRegister.RelType.Out)relType, (Register.Object.Out)direction, (NeoRegister.Node.Out)startId, (NeoRegister.Node.Out)neighborId);
        Assert.assertThat(ExpandTestUtils.rows(cursor, relId, relType, (Register.ObjectRegister<Direction>)direction, startId, neighborId), (Matcher)Matchers.equalTo(Arrays.asList(ExpandTestUtils.row(1L, 0, Direction.BOTH, 0L, 0L), ExpandTestUtils.row(4L, 0, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(5L, 0, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(8L, 0, Direction.INCOMING, 0L, 2L), ExpandTestUtils.row(9L, 0, Direction.INCOMING, 0L, 2L), ExpandTestUtils.row(10L, 1, Direction.OUTGOING, 0L, 3L), ExpandTestUtils.row(11L, 1, Direction.OUTGOING, 0L, 4L), ExpandTestUtils.row(13L, 0, Direction.INCOMING, 0L, 6L), ExpandTestUtils.row(14L, 1, Direction.OUTGOING, 0L, 7L))));
        Assert.assertFalse((String)"Should not contain any more rows.", (boolean)cursor.next());
    }

    @Test
    public void shouldAllowMultipleInputRows() throws Exception {
        final long nodeId = this.createGraph();
        DataWriteOperations write = this.dataWriteOperationsInNewTransaction();
        final long emptyNodeId = write.nodeCreate();
        this.commit();
        ReadOperations ops = this.readOperationsInNewTransaction();
        NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
        NeoRegister.NodeRegister startId = NeoRegisters.newNodeRegister();
        NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
        Register.ObjectRegister direction = Registers.newObjectRegister();
        NeoRegister.NodeRegister neighborId = NeoRegisters.newNodeRegister();
        final NeoRegister.NodeRegister nodeRegister = NeoRegisters.newNodeRegister();
        final Register.ObjectRegister typesRegister = Registers.newObjectRegister();
        final Register.ObjectRegister directionRegister = Registers.newObjectRegister();
        Cursor inputCursor = new Cursor(){
            private int count = 0;

            public boolean next() {
                switch (this.count++) {
                    case 0: {
                        nodeRegister.write(nodeId);
                        typesRegister.write((Object)new int[]{ExpandIT.this.relType1});
                        directionRegister.write((Object)Direction.INCOMING);
                        return true;
                    }
                    case 1: {
                        nodeRegister.write(emptyNodeId);
                        typesRegister.write((Object)new int[]{ExpandIT.this.relType1});
                        directionRegister.write((Object)Direction.INCOMING);
                        return true;
                    }
                    case 2: {
                        nodeRegister.write(emptyNodeId + 999L);
                        typesRegister.write((Object)new int[]{ExpandIT.this.relType1});
                        directionRegister.write((Object)Direction.INCOMING);
                        return true;
                    }
                    case 3: {
                        nodeRegister.write(nodeId);
                        typesRegister.write((Object)new int[]{ExpandIT.this.relType2});
                        directionRegister.write((Object)Direction.OUTGOING);
                        return true;
                    }
                }
                return false;
            }

            public void reset() {
            }

            public void close() {
            }
        };
        Cursor cursor = ops.expand(inputCursor, (NeoRegister.Node.In)nodeRegister, (Register.Object.In)typesRegister, (Register.Object.In)directionRegister, (NeoRegister.Relationship.Out)relId, (NeoRegister.RelType.Out)relType, (Register.Object.Out)direction, (NeoRegister.Node.Out)startId, (NeoRegister.Node.Out)neighborId);
        Assert.assertThat(ExpandTestUtils.rows(cursor, relId, relType, (Register.ObjectRegister<Direction>)direction, startId, neighborId), (Matcher)Matchers.equalTo(Arrays.asList(ExpandTestUtils.row(0L, 0, Direction.BOTH, 0L, 0L), ExpandTestUtils.row(1L, 0, Direction.BOTH, 0L, 0L), ExpandTestUtils.row(4L, 0, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(5L, 0, Direction.INCOMING, 0L, 1L), ExpandTestUtils.row(8L, 0, Direction.INCOMING, 0L, 2L), ExpandTestUtils.row(9L, 0, Direction.INCOMING, 0L, 2L), ExpandTestUtils.row(10L, 1, Direction.OUTGOING, 0L, 3L), ExpandTestUtils.row(11L, 1, Direction.OUTGOING, 0L, 4L))));
        Assert.assertFalse((String)"Should not contain any more rows.", (boolean)cursor.next());
    }

    @Test
    public void resetAndCloseShouldPropagateWithLocalTxState() throws Exception {
        long nodeId = this.createGraph();
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
        NeoRegister.NodeRegister startId = NeoRegisters.newNodeRegister();
        NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
        Register.ObjectRegister direction = Registers.newObjectRegister();
        NeoRegister.NodeRegister neighborId = NeoRegisters.newNodeRegister();
        ops.relationshipDelete(0L);
        ops.relationshipCreate(this.relType1, nodeId, ops.nodeCreate());
        ops.relationshipCreate(this.relType1, ops.nodeCreate(), nodeId);
        Cursor inputCursor = (Cursor)Mockito.spy((Object)new Cursors.CountDownCursor(1));
        Cursor cursor = ops.expand(inputCursor, (NeoRegister.Node.In)NeoRegisters.newNodeRegister((long)nodeId), (Register.Object.In)Registers.newObjectRegister((Object)new int[]{this.relType1}), (Register.Object.In)Registers.newObjectRegister((Object)Direction.INCOMING), (NeoRegister.Relationship.Out)relId, (NeoRegister.RelType.Out)relType, (Register.Object.Out)direction, (NeoRegister.Node.Out)startId, (NeoRegister.Node.Out)neighborId);
        while (cursor.next()) {
        }
        cursor.reset();
        ((Cursor)Mockito.verify((Object)inputCursor)).reset();
        Assert.assertThat(ExpandTestUtils.rows(cursor, relId, relType, (Register.ObjectRegister<Direction>)direction, startId, neighborId), (Matcher)Matchers.equalTo(Arrays.asList(ExpandTestUtils.row(1L, this.relType1, Direction.BOTH, nodeId, 0L), ExpandTestUtils.row(4L, this.relType1, Direction.INCOMING, nodeId, 1L), ExpandTestUtils.row(5L, this.relType1, Direction.INCOMING, nodeId, 1L), ExpandTestUtils.row(8L, this.relType1, Direction.INCOMING, nodeId, 2L), ExpandTestUtils.row(9L, this.relType1, Direction.INCOMING, nodeId, 2L), ExpandTestUtils.row(13L, this.relType1, Direction.INCOMING, nodeId, 6L))));
        Assert.assertFalse((String)"Should not contain any more rows.", (boolean)cursor.next());
        cursor.close();
        ((Cursor)Mockito.verify((Object)inputCursor)).close();
    }

    @Test
    public void resetAndCloseShouldPropagate() throws Exception {
        long nodeId = this.createGraph();
        ReadOperations ops = this.readOperationsInNewTransaction();
        NeoRegister.RelationshipRegister relId = NeoRegisters.newRelationshipRegister();
        NeoRegister.NodeRegister startId = NeoRegisters.newNodeRegister();
        NeoRegister.RelTypeRegister relType = NeoRegisters.newRelTypeRegister();
        Register.ObjectRegister direction = Registers.newObjectRegister();
        NeoRegister.NodeRegister neighborId = NeoRegisters.newNodeRegister();
        Cursor inputCursor = (Cursor)Mockito.spy((Object)new Cursors.CountDownCursor(1));
        Cursor cursor = ops.expand(inputCursor, (NeoRegister.Node.In)NeoRegisters.newNodeRegister((long)nodeId), (Register.Object.In)Registers.newObjectRegister((Object)new int[]{this.relType1}), (Register.Object.In)Registers.newObjectRegister((Object)Direction.INCOMING), (NeoRegister.Relationship.Out)relId, (NeoRegister.RelType.Out)relType, (Register.Object.Out)direction, (NeoRegister.Node.Out)startId, (NeoRegister.Node.Out)neighborId);
        while (cursor.next()) {
        }
        cursor.reset();
        ((Cursor)Mockito.verify((Object)inputCursor)).reset();
        Assert.assertThat(ExpandTestUtils.rows(cursor, relId, relType, (Register.ObjectRegister<Direction>)direction, startId, neighborId), (Matcher)Matchers.equalTo(Arrays.asList(ExpandTestUtils.row(0L, this.relType1, Direction.BOTH, nodeId, 0L), ExpandTestUtils.row(1L, this.relType1, Direction.BOTH, nodeId, 0L), ExpandTestUtils.row(4L, this.relType1, Direction.INCOMING, nodeId, 1L), ExpandTestUtils.row(5L, this.relType1, Direction.INCOMING, nodeId, 1L), ExpandTestUtils.row(8L, this.relType1, Direction.INCOMING, nodeId, 2L), ExpandTestUtils.row(9L, this.relType1, Direction.INCOMING, nodeId, 2L))));
        Assert.assertFalse((String)"Should not contain any more rows.", (boolean)cursor.next());
        cursor.close();
        ((Cursor)Mockito.verify((Object)inputCursor)).close();
    }

    private long createGraph() throws KernelException {
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        this.relType1 = ops.relationshipTypeGetOrCreateForName("TYPE1");
        this.relType2 = ops.relationshipTypeGetOrCreateForName("TYPE2");
        long nodeId = ops.nodeCreate();
        ops.relationshipCreate(this.relType1, nodeId, nodeId);
        ops.relationshipCreate(this.relType1, nodeId, nodeId);
        for (int i = 0; i < 2; ++i) {
            long target = ops.nodeCreate();
            ops.relationshipCreate(this.relType1, nodeId, target);
            ops.relationshipCreate(this.relType1, nodeId, target);
            ops.relationshipCreate(this.relType1, target, nodeId);
            ops.relationshipCreate(this.relType1, target, nodeId);
        }
        ops.relationshipCreate(this.relType2, nodeId, ops.nodeCreate());
        ops.relationshipCreate(this.relType2, nodeId, ops.nodeCreate());
        this.commit();
        return nodeId;
    }
}

