/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.index.LegacyIndexStore;

public class SchemaTransactionStateTest {
    private final int labelId1 = 10;
    private final int labelId2 = 12;
    private final int key1 = 45;
    private final int key2 = 46;
    private final long nodeId = 20L;
    private StoreReadLayer store;
    private TransactionState txState;
    private StateHandlingStatementOperations txContext;
    private KernelStatement state;

    @Test
    public void addedRuleShouldBeVisibleInTx() throws Exception {
        this.commitNoLabels();
        IndexDescriptor rule = this.txContext.indexCreate(this.state, 10, 45);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule}), (Object)IteratorUtil.asSet((Iterator)this.txContext.indexesGetForLabel(this.state, 10)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetForLabel(10);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule}), (Object)IteratorUtil.asSet((Iterator)this.txContext.indexesGetAll(this.state)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetAll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.store});
    }

    @Test
    public void addedRulesShouldBeVisibleInTx() throws Exception {
        this.commitNoLabels();
        IndexDescriptor rule1 = this.txContext.indexCreate(this.state, 10, 45);
        IndexDescriptor rule2 = this.txContext.indexCreate(this.state, 12, 46);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule1}), (Object)IteratorUtil.asSet((Iterator)this.txContext.indexesGetForLabel(this.state, 10)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetForLabel(10);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule2}), (Object)IteratorUtil.asSet((Iterator)this.txContext.indexesGetForLabel(this.state, 12)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetForLabel(12);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule1, rule2}), (Object)IteratorUtil.asSet((Iterator)this.txContext.indexesGetAll(this.state)));
        ((StoreReadLayer)Mockito.verify((Object)this.store)).indexesGetAll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.store});
    }

    @Test
    public void addedAdditionalRuleShouldBeVisibleInTx() throws Exception {
        this.commitNoLabels();
        IndexDescriptor rule1 = this.txContext.indexCreate(this.state, 10, 45);
        IndexDescriptor rule2 = this.txContext.indexCreate(this.state, 10, 46);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{rule1, rule2}), (Object)IteratorUtil.asSet((Iterator)this.txContext.indexesGetForLabel(this.state, 10)));
    }

    @Test
    public void creatingAnIndexShouldBePopulatingStateWithinTX() throws Exception {
        this.commitLabels(10);
        IndexDescriptor rule = this.txContext.indexCreate(this.state, 10, 45);
        Assert.assertEquals((Object)InternalIndexState.POPULATING, (Object)this.txContext.indexGetState(this.state, rule));
    }

    @Test
    public void shouldReturnNonExistentRuleAddedInTransaction() throws Exception {
        this.txContext.indexCreate(this.state, 10, 45);
        IndexDescriptor rule = this.txContext.indexesGetForLabelAndPropertyKey(this.state, 10, 45);
        Iterator labelRules = this.txContext.indexesGetForLabel(this.state, 10);
        IndexDescriptor expectedRule = new IndexDescriptor(10, 45);
        Assert.assertEquals((Object)expectedRule, (Object)rule);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{expectedRule}), (Object)IteratorUtil.asSet((Iterator)labelRules));
    }

    @Test
    public void shouldReturnNonExistentRuleAddedInTransactionFromLookup() throws Exception {
        IndexDescriptor existingRule1 = new IndexDescriptor(10, 45);
        Mockito.when((Object)this.store.indexesGetForLabelAndPropertyKey(10, 45)).thenReturn((Object)existingRule1);
        IndexDescriptor existingRule2 = new IndexDescriptor(12, 46);
        Mockito.when((Object)this.store.indexesGetForLabelAndPropertyKey(12, 46)).thenReturn((Object)existingRule2);
        this.txContext.indexCreate(this.state, 10, 46);
        IndexDescriptor rule = this.txContext.indexesGetForLabelAndPropertyKey(this.state, 10, 46);
        Assert.assertEquals((Object)new IndexDescriptor(10, 46), (Object)rule);
    }

    @Test
    public void shouldNotReturnRulesAddedInTransactionWithDifferentLabelOrPropertyFromLookup() throws Exception {
        IndexDescriptor existingRule1 = new IndexDescriptor(10, 45);
        Mockito.when((Object)this.store.indexesGetForLabelAndPropertyKey(10, 45)).thenReturn((Object)existingRule1);
        IndexDescriptor existingRule2 = new IndexDescriptor(12, 46);
        Mockito.when((Object)this.store.indexesGetForLabelAndPropertyKey(12, 46)).thenReturn((Object)existingRule2);
        this.txContext.indexCreate(this.state, 10, 46);
        IndexDescriptor lookupRule1 = this.txContext.indexesGetForLabelAndPropertyKey(this.state, 10, 45);
        IndexDescriptor lookupRule2 = this.txContext.indexesGetForLabelAndPropertyKey(this.state, 12, 46);
        Assert.assertEquals((Object)existingRule1, (Object)lookupRule1);
        Assert.assertEquals((Object)existingRule2, (Object)lookupRule2);
    }

    @Test
    public void shouldNotReturnExistentRuleDroppedInTransaction() throws Exception {
        IndexDescriptor rule = new IndexDescriptor(10, 45);
        Mockito.when((Object)this.store.indexesGetForLabel(10)).thenReturn(Iterables.option((Object)rule).iterator());
        this.txContext.indexDrop(this.state, rule);
        Assert.assertNull((Object)this.txContext.indexesGetForLabelAndPropertyKey(this.state, 10, 45));
        Iterator rulesByLabel = this.txContext.indexesGetForLabel(this.state, 10);
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(IndexDescriptor.class), (Object)IteratorUtil.asSet((Iterator)rulesByLabel));
    }

    private <E extends Exception> void assertException(ExceptionExpectingFunction<E> function, Class<? extends E> exception) {
        block2: {
            try {
                function.call();
                Assert.fail((String)("Should have thrown " + exception.getName() + " exception"));
            }
            catch (Exception e) {
                if (exception.isAssignableFrom(e.getClass())) break block2;
                throw Exceptions.launderedException((Throwable)e);
            }
        }
    }

    @Before
    public void before() throws Exception {
        this.txState = new TxState();
        this.state = StatementOperationsTestHelper.mockedState(this.txState);
        this.store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)this.store.indexesGetForLabel(10)).then(SchemaTransactionStateTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetForLabel(12)).then(SchemaTransactionStateTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetAll()).then(SchemaTransactionStateTest.asAnswer(Collections.emptyList()));
        this.txContext = new StateHandlingStatementOperations(this.store, (LegacyPropertyTrackers)Mockito.mock(LegacyPropertyTrackers.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (LegacyIndexStore)Mockito.mock(LegacyIndexStore.class));
    }

    private static <T> Answer<Iterator<T>> asAnswer(final Iterable<T> values) {
        return new Answer<Iterator<T>>(){

            public Iterator<T> answer(InvocationOnMock invocation) throws Throwable {
                return values.iterator();
            }
        };
    }

    private static Labels labels(long nodeId, Integer ... labelIds) {
        return new Labels(nodeId, labelIds);
    }

    private void commitLabels(Labels ... labels) throws Exception {
        HashMap<Integer, ArrayList<Long>> allLabels = new HashMap<Integer, ArrayList<Long>>();
        for (Labels nodeLabels : labels) {
            Mockito.when((Object)this.store.nodeGetLabels(nodeLabels.nodeId)).then(SchemaTransactionStateTest.asAnswer(Arrays.asList(nodeLabels.labelIds)));
            Integer[] arr$ = nodeLabels.labelIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int label = arr$[i$];
                Mockito.when((Object)this.store.nodeHasLabel(nodeLabels.nodeId, label)).thenReturn((Object)true);
                ArrayList<Long> nodes = (ArrayList<Long>)allLabels.get(label);
                if (nodes == null) {
                    nodes = new ArrayList<Long>();
                    allLabels.put(label, nodes);
                }
                nodes.add(nodeLabels.nodeId);
            }
        }
        for (Map.Entry entry : allLabels.entrySet()) {
            Mockito.when((Object)this.store.nodesGetForLabel(this.state, ((Integer)entry.getKey()).intValue())).then(SchemaTransactionStateTest.asAnswer((Iterable)entry.getValue()));
        }
    }

    private void commitNoLabels() throws Exception {
        this.commitLabels(new Integer[0]);
    }

    private void commitLabels(Integer ... labels) throws Exception {
        this.commitLabels(SchemaTransactionStateTest.labels(20L, labels));
    }

    private static class Labels {
        private final long nodeId;
        private final Integer[] labelIds;

        Labels(long nodeId, Integer ... labelIds) {
            this.nodeId = nodeId;
            this.labelIds = labelIds;
        }
    }

    private static interface ExceptionExpectingFunction<E extends Exception> {
        public void call() throws E;
    }
}

