/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.concurrent.Callable;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;

class CustomCacheProvider
extends CacheProvider {
    private final Callable<Cache<NodeImpl>> nodeCache;
    private final Callable<Cache<RelationshipImpl>> relCache;

    CustomCacheProvider(String name, Callable<Cache<NodeImpl>> nodeCache, Callable<Cache<RelationshipImpl>> relCache) {
        super(name, "a custom cache provider");
        this.nodeCache = nodeCache;
        this.relCache = relCache;
    }

    public Cache<NodeImpl> newNodeCache(StringLogger logger, Config config, Monitors monitors) {
        try {
            return this.nodeCache.call();
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    public Cache<RelationshipImpl> newRelationshipCache(StringLogger logger, Config config, Monitors monitors) {
        try {
            return this.relCache.call();
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }
}

