/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.HashMap;
import java.util.LinkedList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.cache.ClockCache;

public class TestClockCache {
    @Test
    public void testCreate() {
        try {
            new ClockCache("TestCache", 0);
            Assert.fail((String)"Illegal maxSize should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ClockCache cache = new ClockCache("TestCache", 70);
        try {
            cache.put(null, new Object());
            Assert.fail((String)"Null key should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cache.put(new Object(), null);
            Assert.fail((String)"Null element should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cache.get(null);
            Assert.fail((String)"Null key should throw exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            cache.remove(null);
            Assert.fail((String)"Null key should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        cache.put(new Object(), new Object());
        cache.clear();
    }

    @Test
    public void testSimple() {
        ClockCacheTest cache = new ClockCacheTest("TestCache", 3);
        HashMap<String, Integer> valueToKey = new HashMap<String, Integer>();
        HashMap<Integer, String> keyToValue = new HashMap<Integer, String>();
        String s1 = new String("1");
        Integer key1 = new Integer(1);
        valueToKey.put(s1, key1);
        keyToValue.put(key1, s1);
        String s2 = new String("2");
        Integer key2 = new Integer(2);
        valueToKey.put(s2, key2);
        keyToValue.put(key2, s2);
        String s3 = new String("3");
        Integer key3 = new Integer(3);
        valueToKey.put(s3, key3);
        keyToValue.put(key3, s3);
        String s4 = new String("4");
        Integer key4 = new Integer(4);
        valueToKey.put(s4, key4);
        keyToValue.put(key4, s4);
        String s5 = new String("5");
        Integer key5 = new Integer(5);
        valueToKey.put(s5, key5);
        keyToValue.put(key5, s5);
        LinkedList cleanedElements = new LinkedList();
        LinkedList existingElements = new LinkedList();
        cache.put(key1, s1);
        cache.put(key2, s2);
        cache.put(key3, s3);
        Assert.assertEquals(null, cache.getLastCleanedElement());
        String fromKey2 = (String)cache.get(key2);
        Assert.assertEquals((Object)s2, (Object)fromKey2);
        String fromKey1 = (String)cache.get(key1);
        Assert.assertEquals((Object)s1, (Object)fromKey1);
        String fromKey3 = (String)cache.get(key3);
        Assert.assertEquals((Object)s3, (Object)fromKey3);
        cache.put(key4, s4);
        Assert.assertFalse((boolean)s4.equals(cache.getLastCleanedElement()));
        cleanedElements.add(valueToKey.get(cache.getLastCleanedElement()));
        existingElements.remove(valueToKey.get(cache.getLastCleanedElement()));
        cache.put(key5, s5);
        Assert.assertFalse((boolean)s4.equals(cache.getLastCleanedElement()));
        Assert.assertFalse((boolean)s5.equals(cache.getLastCleanedElement()));
        cleanedElements.add(valueToKey.get(cache.getLastCleanedElement()));
        existingElements.remove(valueToKey.get(cache.getLastCleanedElement()));
        int size = cache.size();
        Assert.assertEquals((long)3L, (long)size);
        for (Integer key : cleanedElements) {
            Assert.assertEquals(null, (Object)cache.get(key));
        }
        for (Integer key : existingElements) {
            Assert.assertEquals(keyToValue.get(key), (Object)cache.get(key));
        }
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
        for (Integer key : keyToValue.keySet()) {
            Assert.assertEquals(null, (Object)cache.get(key));
        }
    }

    @Test
    public void shouldUpdateSizeWhenRemoving() throws Exception {
        ClockCache cache = new ClockCache("foo", 3);
        cache.put((Object)"bar", (Object)42);
        cache.put((Object)"baz", (Object)87);
        cache.remove((Object)"bar");
        Assert.assertThat((Object)cache.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    private static class ClockCacheTest<K, E>
    extends ClockCache<K, E> {
        private E cleanedElement = null;

        ClockCacheTest(String name, int maxSize) {
            super(name, maxSize);
        }

        public void elementCleaned(E element) {
            this.cleanedElement = element;
        }

        E getLastCleanedElement() {
            return this.cleanedElement;
        }
    }
}

