/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.ImpermanentDatabaseRule;

public class ConcurrentCreateAndGetRelationshipsIT {
    @Rule
    public final ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private static final RelationshipType RELTYPE = MyRelTypes.TEST;

    @Test
    public void tryToReproduceTheIssue() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        CountDownLatch startSignal = new CountDownLatch(1);
        AtomicBoolean stopSignal = new AtomicBoolean();
        AtomicReference<Exception> failure = new AtomicReference<Exception>();
        Node parentNode = this.createNode(db);
        Collection<Worker> workers = this.createWorkers(db, startSignal, stopSignal, failure, parentNode);
        startSignal.countDown();
        Thread.sleep(500L);
        stopSignal.set(true);
        this.awaitWorkersToEnd(workers);
        if (failure.get() != null) {
            throw new Exception("A worker failed", failure.get());
        }
    }

    private void awaitWorkersToEnd(Collection<Worker> workers) throws InterruptedException {
        for (Worker worker : workers) {
            worker.join();
        }
    }

    private Collection<Worker> createWorkers(GraphDatabaseService db, CountDownLatch startSignal, AtomicBoolean stopSignal, AtomicReference<Exception> failure, Node parentNode) {
        ArrayList<Worker> workers = new ArrayList<Worker>();
        for (int i = 0; i < 2; ++i) {
            workers.add(this.newWorker(db, startSignal, stopSignal, failure, parentNode));
        }
        return workers;
    }

    private Worker newWorker(GraphDatabaseService db, CountDownLatch startSignal, AtomicBoolean stopSignal, AtomicReference<Exception> failure, Node parentNode) {
        Worker worker = new Worker(db, startSignal, stopSignal, failure, parentNode);
        worker.start();
        return worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createNode(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        try {
            Node node = db.createNode();
            tx.success();
            Node node2 = node;
            return node2;
        }
        finally {
            tx.finish();
        }
    }

    private static class Worker
    extends Thread {
        private final GraphDatabaseService db;
        private final CountDownLatch startSignal;
        private final AtomicReference<Exception> failure;
        private final Node parentNode;
        private final AtomicBoolean stopSignal;

        public Worker(GraphDatabaseService db, CountDownLatch startSignal, AtomicBoolean stopSignal, AtomicReference<Exception> failure, Node parentNode) {
            this.db = db;
            this.startSignal = startSignal;
            this.stopSignal = stopSignal;
            this.failure = failure;
            this.parentNode = parentNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.awaitStartSignal();
            while (this.failure.get() == null && !this.stopSignal.get()) {
                Transaction tx = this.db.beginTx();
                try {
                    IteratorUtil.count((Iterable)this.parentNode.getRelationships(RELTYPE, Direction.OUTGOING));
                    this.parentNode.createRelationshipTo(this.db.createNode(), RELTYPE);
                    tx.success();
                }
                catch (Exception e) {
                    this.failure.compareAndSet(null, e);
                }
                finally {
                    tx.finish();
                }
            }
        }

        private void awaitStartSignal() {
            try {
                this.startSignal.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

