/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.Pair;
import org.neo4j.test.TargetDirectory;

@Ignore(value="Good for driving out problems with loading/heaviness of property records")
public class ConcurrentPropertyAccessIT {
    private GraphDatabaseService db;
    private Node[] nodes;

    @Test
    public void tryTriggerIssueWithConcurrentlySettingAndReadingProperties() throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.submit(new SetPropertyWorker());
        executor.submit(new RemovePropertyWorker());
        executor.submit(new GetPropertyWorker());
        executor.submit(new ReplaceNodeWorker());
        this.waitIndefinitely();
    }

    private void waitIndefinitely() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Integer.MAX_VALUE);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    }

    protected Pair<Integer, Node> getNode(Random random, boolean takeOut) {
        Node[] nodeArray = this.nodes;
        synchronized (this.nodes) {
            int index;
            Node node;
            while (null == (node = this.nodes[index = random.nextInt(this.nodes.length)])) {
            }
            if (takeOut) {
                this.nodes[index] = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Pair.of((Object)index, (Object)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNode(int i, Node node) {
        Node[] nodeArray = this.nodes;
        synchronized (this.nodes) {
            this.nodes[i] = node;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private Object randomLongPropertyValue(int length, Random random) {
        String[] parts = new String[]{"bozo", "bimbo", "basil", "bongo"};
        StringBuilder result = new StringBuilder(4 * length);
        for (int i = 0; i < length; ++i) {
            result.append(parts[random.nextInt(parts.length)]);
        }
        return result.toString();
    }

    private String randomPropertyKey(Random random) {
        return random.nextBoolean() ? "name" : "animals";
    }

    @Before
    public void before() throws Exception {
        this.db = new GraphDatabaseFactory().newEmbeddedDatabase(TargetDirectory.forTest(this.getClass()).makeGraphDbDir().getAbsolutePath());
        this.nodes = this.createInitialNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node[] createInitialNodes() {
        Node[] nodes = new Node[100];
        Transaction tx = this.db.beginTx();
        try {
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = this.db.createNode();
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
        return nodes;
    }

    @After
    public void after() throws Exception {
        this.db.shutdown();
    }

    private class ReplaceNodeWorker
    extends Worker {
        private ReplaceNodeWorker() {
        }

        @Override
        protected void doSomething() throws Throwable {
            Pair<Integer, Node> pair = ConcurrentPropertyAccessIT.this.getNode(this.random, true);
            int index = (Integer)pair.first();
            Node node = (Node)pair.other();
            node.delete();
            ConcurrentPropertyAccessIT.this.setNode(index, ConcurrentPropertyAccessIT.this.db.createNode());
        }
    }

    private class RemovePropertyWorker
    extends Worker {
        private RemovePropertyWorker() {
        }

        @Override
        protected void doSomething() throws Throwable {
            Pair<Integer, Node> pair = ConcurrentPropertyAccessIT.this.getNode(this.random, false);
            Node node = (Node)pair.other();
            node.removeProperty(ConcurrentPropertyAccessIT.this.randomPropertyKey(this.random));
        }
    }

    private class GetPropertyWorker
    extends Worker {
        private GetPropertyWorker() {
        }

        @Override
        protected void doSomething() throws Throwable {
            Pair<Integer, Node> pair = ConcurrentPropertyAccessIT.this.getNode(this.random, false);
            Node node = (Node)pair.other();
            node.getProperty(ConcurrentPropertyAccessIT.this.randomPropertyKey(this.random), null);
        }
    }

    private class SetPropertyWorker
    extends Worker {
        private SetPropertyWorker() {
        }

        @Override
        protected void doSomething() throws Throwable {
            Pair<Integer, Node> pair = ConcurrentPropertyAccessIT.this.getNode(this.random, false);
            Node node = (Node)pair.other();
            node.setProperty(ConcurrentPropertyAccessIT.this.randomPropertyKey(this.random), ConcurrentPropertyAccessIT.this.randomLongPropertyValue(this.random.nextInt(8) + 2, this.random));
        }
    }

    private abstract class Worker
    implements Runnable {
        protected final Random random = new Random();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Transaction tx = ConcurrentPropertyAccessIT.this.db.beginTx();
                try {
                    this.doSomething();
                    tx.success();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    System.err.flush();
                    continue;
                }
                finally {
                    tx.finish();
                    continue;
                }
                break;
            }
        }

        protected abstract void doSomething() throws Throwable;
    }
}

