/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.store.CacheUpdateListener;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipIterator;
import org.neo4j.kernel.impl.core.RelationshipLoader;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;

public class RelationshipIteratorIssuesTest {
    @Test
    public void arrayIndexOutOfBoundsInRelTypeArrayWhenCreatingRelationshipsConcurrently() throws Exception {
        CacheUpdateListener cacheUpdateListener = (CacheUpdateListener)Mockito.mock(CacheUpdateListener.class);
        RelationshipLoader loader = (RelationshipLoader)Mockito.mock(RelationshipLoader.class);
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)node.getMoreRelationships((RelationshipLoader)Matchers.eq((Object)loader), (RelIdArray.DirectionWrapper)Matchers.any(RelIdArray.DirectionWrapper.class), (int[])Matchers.any(int[].class), (CacheUpdateListener)Matchers.any(CacheUpdateListener.class))).thenReturn((Object)NodeImpl.LoadStatus.NOTHING);
        ControlledRelIdIterator typeIterator = new ControlledRelIdIterator(0L);
        RelationshipIterator iterator = new RelationshipIterator(new RelIdIterator[]{typeIterator}, node, RelIdArray.DirectionWrapper.OUTGOING, new int[0], loader, false, false, cacheUpdateListener);
        iterator.next();
        typeIterator.queueHasNextAnswers(false, false, true);
        long otherRelationship = 1L;
        long thirdRelationship = 2L;
        typeIterator.add(otherRelationship, thirdRelationship);
        iterator.next();
        long returnedThirdRelationship = iterator.next();
        Assert.assertEquals((long)thirdRelationship, (long)returnedThirdRelationship);
    }

    private static class ControlledRelIdIterator
    implements RelIdIterator {
        private final List<Long> ids;
        private int index;
        private final Queue<Boolean> controlledHasNextResults = new LinkedList<Boolean>();

        ControlledRelIdIterator(Long ... ids) {
            this.ids = new ArrayList<Long>(Arrays.asList(ids));
        }

        void add(long ... ids) {
            for (long id : ids) {
                this.ids.add(id);
            }
        }

        void queueHasNextAnswers(boolean ... answers) {
            for (boolean answer : answers) {
                this.controlledHasNextResults.add(answer);
            }
        }

        public int getType() {
            return 0;
        }

        public boolean hasNext() {
            Boolean controlledAnswer = this.controlledHasNextResults.poll();
            if (controlledAnswer != null) {
                return controlledAnswer;
            }
            return this.index < this.ids.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.ids.get(this.index++);
        }

        public RelIdIterator updateSource(RelIdArray newSource, RelIdArray.DirectionWrapper direction) {
            throw new UnsupportedOperationException();
        }

        public void doAnotherRound() {
            throw new UnsupportedOperationException();
        }
    }
}

