/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.ArrayBasedPrimitive;

public class TestBinarySearchPerformance {
    @Ignore(value="Not a unit test, enable to try out performance difference")
    @Test
    public void measurePerformance() throws Exception {
        for (int i = 1; i < 100; ++i) {
            System.out.println("===" + i + "===");
            this.test(i);
        }
    }

    private void test(int size) {
        final DefinedProperty[] array = this.datas(size);
        int times = 10000000;
        this.measure("scan", new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10000000; ++i) {
                    TestBinarySearchPerformance.this.doScan(array, i % array.length);
                }
            }
        });
        this.measure("bs", new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10000000; ++i) {
                    TestBinarySearchPerformance.this.doBinarySearch(array, 0);
                }
            }
        });
    }

    private DefinedProperty[] datas(int size) {
        DefinedProperty[] result = new DefinedProperty[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Property.byteProperty((int)i, (byte)0);
        }
        return result;
    }

    private DefinedProperty doScan(DefinedProperty[] array, long keyId) {
        for (DefinedProperty pd : array) {
            if ((long)pd.propertyKeyId() != keyId) continue;
            return pd;
        }
        return null;
    }

    private DefinedProperty doBinarySearch(DefinedProperty[] array, int keyId) {
        return array[Arrays.binarySearch(array, keyId, ArrayBasedPrimitive.PROPERTY_DATA_COMPARATOR_FOR_BINARY_SEARCH)];
    }

    private void measure(String name, Runnable runnable) {
        runnable.run();
        System.out.print(name + "... ");
        Measurement m = new Measurement();
        for (int i = 0; i < 3; ++i) {
            long t = System.currentTimeMillis();
            runnable.run();
            m.add(System.currentTimeMillis() - t);
        }
        System.out.println(name + ":" + m.average() + " (lower=better)");
    }

    private class Measurement {
        private long time;
        private int count;

        private Measurement() {
        }

        public void add(long time) {
            this.time += time;
            ++this.count;
        }

        public double average() {
            return (double)this.time / (double)this.count;
        }
    }
}

