/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.index.IndexCommandFactory;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.LegacyIndexProviderTransaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.LegacyIndex;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;

public class DummyIndexImplementation
implements IndexImplementation {
    private static final LegacyIndexHits NO_HITS = new EmptyHits();
    private static final NeoCommandHandler NO_APPLIER = new NeoCommandHandler.Adapter();

    public Map<String, String> fillInDefaults(Map<String, String> config) {
        return config;
    }

    public boolean configMatches(Map<String, String> storedConfig, Map<String, String> suppliedConfig) {
        return true;
    }

    private boolean failing(Map<String, String> config) {
        return Boolean.parseBoolean(config.get("fail_on_mutate"));
    }

    public LegacyIndexProviderTransaction newTransaction(IndexCommandFactory commandFactory) {
        return new LegacyIndexProviderTransaction(){

            public LegacyIndex relationshipIndex(String indexName, Map<String, String> configuration) {
                return new EmptyLegacyIndex(DummyIndexImplementation.this.failing(configuration));
            }

            public LegacyIndex nodeIndex(String indexName, Map<String, String> configuration) {
                return new EmptyLegacyIndex(DummyIndexImplementation.this.failing(configuration));
            }

            public void close() {
            }
        };
    }

    public NeoCommandHandler newApplier(boolean recovery) {
        return NO_APPLIER;
    }

    public void force() {
    }

    public ResourceIterator<File> listStoreFiles() {
        return IteratorUtil.emptyIterator();
    }

    private static class EmptyLegacyIndex
    implements LegacyIndex {
        private final boolean failing;

        private EmptyLegacyIndex(boolean failing) {
            this.failing = failing;
        }

        public void remove(long entity) {
            this.mutate();
        }

        public void remove(long entity, String key) {
            this.mutate();
        }

        public void remove(long entity, String key, Object value) {
            this.mutate();
        }

        public LegacyIndexHits query(Object queryOrQueryObject, long startNode, long endNode) {
            return NO_HITS;
        }

        public LegacyIndexHits query(String key, Object queryOrQueryObject, long startNode, long endNode) {
            return NO_HITS;
        }

        public LegacyIndexHits query(Object queryOrQueryObject) {
            return NO_HITS;
        }

        public LegacyIndexHits query(String key, Object queryOrQueryObject) {
            return NO_HITS;
        }

        public LegacyIndexHits get(String key, Object value, long startNode, long endNode) {
            return NO_HITS;
        }

        public LegacyIndexHits get(String key, Object value) {
            return NO_HITS;
        }

        public void drop() {
            this.mutate();
        }

        public void addRelationship(long entity, String key, Object value, long startNode, long endNode) {
            this.mutate();
        }

        public void addNode(long entity, String key, Object value) {
            this.mutate();
        }

        private void mutate() {
            if (this.failing) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class EmptyHits
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator
    implements LegacyIndexHits {
        private EmptyHits() {
        }

        public void close() {
        }

        public int size() {
            return 0;
        }

        public float currentScore() {
            return 0.0f;
        }

        protected boolean fetchNext() {
            return false;
        }
    }
}

